/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QHIJRI_CALENDAR_DATA_P_H
#define QHIJRI_CALENDAR_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/private/qglobal_p.h>
#include <QtCore/private/qcalendarbackend_p.h>

QT_BEGIN_NAMESPACE

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2021-04-26 from the
    Common Locale Data Repository v39

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/locale_database/.
*/

static const QCalendarLocale locale_data[] = {
   //  lang   script terr   sShort  sLong   sNarrow short   long    narrow
      {     1,     0,     0,{ 0,79 },{ 79,107 },{ 186,29 },{ 0,79 },{ 79,107 },{ 186,29 }}, // C/AnyScript/AnyCountry
      {     3,     7,    69,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Oromo/Latin/Ethiopia
      {     3,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Oromo/Latin/Kenya
      {     4,     7,    69,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Afar/Latin/Ethiopia
      {     5,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Afrikaans/Latin/South Africa
      {     5,     7,   148,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Afrikaans/Latin/Namibia
      {     6,     7,     2,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Albanian/Latin/Albania
      {     6,     7,   127,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Albanian/Latin/Macedonia
      {     6,     7,   257,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Albanian/Latin/Kosovo
      {     7,    14,    69,{ 0,79 },{ 242,75 },{ 215,27 },{ 0,79 },{ 242,75 },{ 215,27 }}, // Amharic/Ethiopic/Ethiopia
      {     8,     1,    64,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Egypt
      {     8,     1,     3,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Algeria
      {     8,     1,    17,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Bahrain
      {     8,     1,    42,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Chad
      {     8,     1,    48,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Comoros
      {     8,     1,    59,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Djibouti
      {     8,     1,    67,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Eritrea
      {     8,     1,   103,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Iraq
      {     8,     1,   105,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Israel
      {     8,     1,   109,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Jordan
      {     8,     1,   115,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Kuwait
      {     8,     1,   119,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Lebanon
      {     8,     1,   122,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Libya
      {     8,     1,   136,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Mauritania
      {     8,     1,   145,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Morocco
      {     8,     1,   162,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Oman
      {     8,     1,   165,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Palestinian Territories
      {     8,     1,   175,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Qatar
      {     8,     1,   186,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Saudi Arabia
      {     8,     1,   194,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Somalia
      {     8,     1,   201,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Sudan
      {     8,     1,   207,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Syria
      {     8,     1,   216,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Tunisia
      {     8,     1,   223,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/United Arab Emirates
      {     8,     1,   236,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Western Sahara
      {     8,     1,   237,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/Yemen
      {     8,     1,   254,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/South Sudan
      {     8,     1,   260,{ 317,97 },{ 317,97 },{ 414,27 },{ 317,97 },{ 317,97 },{ 414,27 }}, // Arabic/Arabic/World
      {     9,    10,    11,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Armenian/Armenian/Armenia
      {    10,    11,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Assamese/Bengali/India
      {    12,     7,    15,{ 441,72 },{ 513,111 },{ 215,27 },{ 441,72 },{ 513,111 },{ 215,27 }}, // Azerbaijani/Latin/Azerbaijan
      {    12,     1,   102,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Azerbaijani/Arabic/Iran
      {    12,     2,    15,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Azerbaijani/Cyrillic/Azerbaijan
      {    13,     2,   178,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Bashkir/Cyrillic/Russia
      {    14,     7,   197,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Basque/Latin/Spain
      {    15,    11,    18,{ 624,105 },{ 624,105 },{ 729,27 },{ 624,105 },{ 624,105 },{ 729,27 }}, // Bengali/Bengali/Bangladesh
      {    15,    11,   100,{ 624,105 },{ 624,105 },{ 729,27 },{ 624,105 },{ 624,105 },{ 729,27 }}, // Bengali/Bengali/India
      {    16,    31,    25,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Dzongkha/Tibetan/Bhutan
      {    19,     7,    74,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Breton/Latin/France
      {    20,     2,    33,{ 0,79 },{ 756,97 },{ 215,27 },{ 0,79 },{ 756,97 },{ 215,27 }}, // Bulgarian/Cyrillic/Bulgaria
      {    21,    25,   147,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Burmese/Myanmar/Myanmar
      {    22,     2,    20,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Belarusian/Cyrillic/Belarus
      {    23,    20,    36,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Khmer/Khmer/Cambodia
      {    24,     7,   197,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Catalan/Latin/Spain
      {    24,     7,     5,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Catalan/Latin/Andorra
      {    24,     7,    74,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Catalan/Latin/France
      {    24,     7,   106,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Catalan/Latin/Italy
      {    25,     5,    44,{ 853,39 },{ 892,38 },{ 215,27 },{ 853,39 },{ 892,38 },{ 215,27 }}, // Chinese/Simplified Han/China
      {    25,     5,    97,{ 853,39 },{ 892,38 },{ 215,27 },{ 853,39 },{ 892,38 },{ 215,27 }}, // Chinese/Simplified Han/Hong Kong
      {    25,     5,   126,{ 853,39 },{ 892,38 },{ 215,27 },{ 853,39 },{ 892,38 },{ 215,27 }}, // Chinese/Simplified Han/Macau
      {    25,     5,   190,{ 853,39 },{ 892,38 },{ 215,27 },{ 853,39 },{ 892,38 },{ 215,27 }}, // Chinese/Simplified Han/Singapore
      {    25,     6,    97,{ 930,72 },{ 930,72 },{ 215,27 },{ 930,72 },{ 930,72 },{ 215,27 }}, // Chinese/Traditional Han/Hong Kong
      {    25,     6,   126,{ 930,72 },{ 930,72 },{ 215,27 },{ 930,72 },{ 930,72 },{ 215,27 }}, // Chinese/Traditional Han/Macau
      {    25,     6,   208,{ 930,72 },{ 930,72 },{ 215,27 },{ 930,72 },{ 930,72 },{ 215,27 }}, // Chinese/Traditional Han/Taiwan
      {    26,     7,    74,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Corsican/Latin/France
      {    27,     7,    54,{ 0,79 },{ 79,107 },{ 1002,39 },{ 0,79 },{ 79,107 },{ 1002,39 }}, // Croatian/Latin/Croatia
      {    27,     7,    27,{ 0,79 },{ 79,107 },{ 1002,39 },{ 0,79 },{ 79,107 },{ 1002,39 }}, // Croatian/Latin/Bosnia And Herzegowina
      {    28,     7,    57,{ 1041,77 },{ 1118,130 },{ 215,27 },{ 1041,77 },{ 1118,130 },{ 215,27 }}, // Czech/Latin/Czech Republic
      {    29,     7,    58,{ 0,79 },{ 1248,107 },{ 215,27 },{ 0,79 },{ 1248,107 },{ 215,27 }}, // Danish/Latin/Denmark
      {    29,     7,    86,{ 0,79 },{ 1248,107 },{ 215,27 },{ 0,79 },{ 1248,107 },{ 215,27 }}, // Danish/Latin/Greenland
      {    30,     7,   151,{ 1355,84 },{ 1439,135 },{ 215,27 },{ 1355,84 },{ 1439,135 },{ 215,27 }}, // Dutch/Latin/Netherlands
      {    30,     7,    12,{ 1355,84 },{ 1439,135 },{ 215,27 },{ 1355,84 },{ 1439,135 },{ 215,27 }}, // Dutch/Latin/Aruba
      {    30,     7,    21,{ 1355,84 },{ 1439,135 },{ 215,27 },{ 1355,84 },{ 1439,135 },{ 215,27 }}, // Dutch/Latin/Belgium
      {    30,     7,   152,{ 1355,84 },{ 1439,135 },{ 215,27 },{ 1355,84 },{ 1439,135 },{ 215,27 }}, // Dutch/Latin/Cura Sao
      {    30,     7,   202,{ 1355,84 },{ 1439,135 },{ 215,27 },{ 1355,84 },{ 1439,135 },{ 215,27 }}, // Dutch/Latin/Suriname
      {    30,     7,   255,{ 1355,84 },{ 1439,135 },{ 215,27 },{ 1355,84 },{ 1439,135 },{ 215,27 }}, // Dutch/Latin/Bonaire
      {    30,     7,   256,{ 1355,84 },{ 1439,135 },{ 215,27 },{ 1355,84 },{ 1439,135 },{ 215,27 }}, // Dutch/Latin/Sint Maarten
      {    31,     7,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/United States
      {    31,     3,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Deseret/United States
      {    31,     7,     4,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/American Samoa
      {    31,     7,     7,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Anguilla
      {    31,     7,     9,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Antigua And Barbuda
      {    31,     7,    13,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Australia
      {    31,     7,    14,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Austria
      {    31,     7,    16,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Bahamas
      {    31,     7,    19,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Barbados
      {    31,     7,    21,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Belgium
      {    31,     7,    22,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Belize
      {    31,     7,    24,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Bermuda
      {    31,     7,    28,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Botswana
      {    31,     7,    31,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/British Indian Ocean Territory
      {    31,     7,    35,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Burundi
      {    31,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Cameroon
      {    31,     7,    38,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Canada
      {    31,     7,    40,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Cayman Islands
      {    31,     7,    45,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Christmas Island
      {    31,     7,    46,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Cocos Islands
      {    31,     7,    51,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Cook Islands
      {    31,     7,    56,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Cyprus
      {    31,     7,    58,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Denmark
      {    31,     7,    60,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Dominica
      {    31,     7,    67,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Eritrea
      {    31,     7,    70,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Falkland Islands
      {    31,     7,    72,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Fiji
      {    31,     7,    73,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Finland
      {    31,     7,    75,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Guernsey
      {    31,     7,    80,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Gambia
      {    31,     7,    82,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Germany
      {    31,     7,    83,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Ghana
      {    31,     7,    84,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Gibraltar
      {    31,     7,    87,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Grenada
      {    31,     7,    89,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Guam
      {    31,     7,    93,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Guyana
      {    31,     7,    97,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Hong Kong
      {    31,     7,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/India
      {    31,     7,   104,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Ireland
      {    31,     7,   105,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Israel
      {    31,     7,   107,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Jamaica
      {    31,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Kenya
      {    31,     7,   112,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Kiribati
      {    31,     7,   120,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Lesotho
      {    31,     7,   121,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Liberia
      {    31,     7,   126,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Macau
      {    31,     7,   128,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Madagascar
      {    31,     7,   129,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Malawi
      {    31,     7,   130,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Malaysia
      {    31,     7,   133,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Malta
      {    31,     7,   134,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Marshall Islands
      {    31,     7,   137,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Mauritius
      {    31,     7,   140,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Micronesia
      {    31,     7,   144,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Montserrat
      {    31,     7,   148,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Namibia
      {    31,     7,   149,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Nauru
      {    31,     7,   151,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Netherlands
      {    31,     7,   154,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/New Zealand
      {    31,     7,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Nigeria
      {    31,     7,   158,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Niue
      {    31,     7,   159,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Norfolk Island
      {    31,     7,   160,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Northern Mariana Islands
      {    31,     7,   163,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Pakistan
      {    31,     7,   164,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Palau
      {    31,     7,   167,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Papua New Guinea
      {    31,     7,   170,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Philippines
      {    31,     7,   171,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Pitcairn
      {    31,     7,   174,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Puerto Rico
      {    31,     7,   179,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Rwanda
      {    31,     7,   180,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Saint Kitts And Nevis
      {    31,     7,   181,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Saint Lucia
      {    31,     7,   182,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Saint Vincent And The Grenadines
      {    31,     7,   183,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Samoa
      {    31,     7,   188,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Seychelles
      {    31,     7,   189,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Sierra Leone
      {    31,     7,   190,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Singapore
      {    31,     7,   192,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Slovenia
      {    31,     7,   193,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Solomon Islands
      {    31,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/South Africa
      {    31,     7,   199,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Saint Helena
      {    31,     7,   201,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Sudan
      {    31,     7,   204,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Swaziland
      {    31,     7,   205,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Sweden
      {    31,     7,   206,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Switzerland
      {    31,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Tanzania
      {    31,     7,   213,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Tokelau
      {    31,     7,   214,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Tonga
      {    31,     7,   215,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Trinidad And Tobago
      {    31,     7,   219,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Turks And Caicos Islands
      {    31,     7,   220,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Tuvalu
      {    31,     7,   221,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Uganda
      {    31,     7,   223,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/United Arab Emirates
      {    31,     7,   224,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/United Kingdom
      {    31,     7,   226,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/United States Minor Outlying Islands
      {    31,     7,   229,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Vanuatu
      {    31,     7,   233,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/British Virgin Islands
      {    31,     7,   234,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/United States Virgin Islands
      {    31,     7,   239,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Zambia
      {    31,     7,   240,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Zimbabwe
      {    31,     7,   249,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Diego Garcia
      {    31,     7,   251,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Isle Of Man
      {    31,     7,   252,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Jersey
      {    31,     7,   254,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/South Sudan
      {    31,     7,   256,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Sint Maarten
      {    31,     7,   260,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/World
      {    31,     7,   261,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // English/Latin/Europe
      {    32,     7,   260,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Esperanto/Latin/World
      {    33,     7,    68,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Estonian/Latin/Estonia
      {    34,     7,    71,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Faroese/Latin/Faroe Islands
      {    34,     7,    58,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Faroese/Latin/Denmark
      {    36,     7,    73,{ 0,79 },{ 1574,130 },{ 215,27 },{ 0,79 },{ 1574,130 },{ 215,27 }}, // Finnish/Latin/Finland
      {    37,     7,    74,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/France
      {    37,     7,     3,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Algeria
      {    37,     7,    21,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Belgium
      {    37,     7,    23,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Benin
      {    37,     7,    34,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Burkina Faso
      {    37,     7,    35,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Burundi
      {    37,     7,    37,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Cameroon
      {    37,     7,    38,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Canada
      {    37,     7,    41,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Central African Republic
      {    37,     7,    42,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Chad
      {    37,     7,    48,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Comoros
      {    37,     7,    49,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Congo Kinshasa
      {    37,     7,    50,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Congo Brazzaville
      {    37,     7,    53,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Ivory Coast
      {    37,     7,    59,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Djibouti
      {    37,     7,    66,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Equatorial Guinea
      {    37,     7,    76,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/French Guiana
      {    37,     7,    77,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/French Polynesia
      {    37,     7,    79,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Gabon
      {    37,     7,    88,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Guadeloupe
      {    37,     7,    91,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Guinea
      {    37,     7,    94,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Haiti
      {    37,     7,   125,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Luxembourg
      {    37,     7,   128,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Madagascar
      {    37,     7,   132,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Mali
      {    37,     7,   135,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Martinique
      {    37,     7,   136,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Mauritania
      {    37,     7,   137,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Mauritius
      {    37,     7,   138,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Mayotte
      {    37,     7,   142,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Monaco
      {    37,     7,   145,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Morocco
      {    37,     7,   153,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/New Caledonia
      {    37,     7,   156,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Niger
      {    37,     7,   176,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Reunion
      {    37,     7,   179,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Rwanda
      {    37,     7,   187,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Senegal
      {    37,     7,   188,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Seychelles
      {    37,     7,   200,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Saint Pierre And Miquelon
      {    37,     7,   206,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Switzerland
      {    37,     7,   207,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Syria
      {    37,     7,   212,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Togo
      {    37,     7,   216,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Tunisia
      {    37,     7,   229,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Vanuatu
      {    37,     7,   235,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Wallis And Futuna Islands
      {    37,     7,   244,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Saint Barthelemy
      {    37,     7,   245,{ 1704,91 },{ 1795,140 },{ 215,27 },{ 1935,91 },{ 1795,140 },{ 215,27 }}, // French/Latin/Saint Martin
      {    38,     7,   151,{ 1355,84 },{ 1439,135 },{ 215,27 },{ 1355,84 },{ 1439,135 },{ 215,27 }}, // Western Frisian/Latin/Netherlands
      {    39,     7,   224,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Gaelic/Latin/United Kingdom
      {    40,     7,   197,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Galician/Latin/Spain
      {    41,    15,    81,{ 2026,74 },{ 2100,125 },{ 215,27 },{ 2026,74 },{ 2100,125 },{ 215,27 }}, // Georgian/Georgian/Georgia
      {    42,     7,    82,{ 0,79 },{ 2225,117 },{ 215,27 },{ 0,79 },{ 2225,117 },{ 215,27 }}, // German/Latin/Germany
      {    42,     7,    14,{ 0,79 },{ 2225,117 },{ 215,27 },{ 0,79 },{ 2225,117 },{ 215,27 }}, // German/Latin/Austria
      {    42,     7,    21,{ 0,79 },{ 2225,117 },{ 215,27 },{ 0,79 },{ 2225,117 },{ 215,27 }}, // German/Latin/Belgium
      {    42,     7,   106,{ 0,79 },{ 2225,117 },{ 215,27 },{ 0,79 },{ 2225,117 },{ 215,27 }}, // German/Latin/Italy
      {    42,     7,   123,{ 0,79 },{ 2225,117 },{ 215,27 },{ 0,79 },{ 2225,117 },{ 215,27 }}, // German/Latin/Liechtenstein
      {    42,     7,   125,{ 0,79 },{ 2225,117 },{ 215,27 },{ 0,79 },{ 2225,117 },{ 215,27 }}, // German/Latin/Luxembourg
      {    42,     7,   206,{ 0,79 },{ 2225,117 },{ 215,27 },{ 0,79 },{ 2225,117 },{ 215,27 }}, // German/Latin/Switzerland
      {    43,    16,    85,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Greek/Greek/Greece
      {    43,    16,    56,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Greek/Greek/Cyprus
      {    44,     7,    86,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Greenlandic/Latin/Greenland
      {    45,     7,   168,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Guarani/Latin/Paraguay
      {    46,    17,   100,{ 2342,75 },{ 2417,99 },{ 215,27 },{ 2342,75 },{ 2417,99 },{ 215,27 }}, // Gujarati/Gujarati/India
      {    47,     7,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Hausa/Latin/Nigeria
      {    47,     1,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Hausa/Arabic/Nigeria
      {    47,     7,    83,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Hausa/Latin/Ghana
      {    47,     7,   156,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Hausa/Latin/Niger
      {    48,    18,   105,{ 2516,96 },{ 2612,117 },{ 215,27 },{ 2516,96 },{ 2729,117 },{ 215,27 }}, // Hebrew/Hebrew/Israel
      {    49,    13,   100,{ 0,79 },{ 2846,109 },{ 215,27 },{ 0,79 },{ 2846,109 },{ 215,27 }}, // Hindi/Devanagari/India
      {    49,     7,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Hindi/Latin/India
      {    50,     7,    98,{ 2955,77 },{ 3032,100 },{ 215,27 },{ 2955,77 },{ 3132,128 },{ 215,27 }}, // Hungarian/Latin/Hungary
      {    51,     7,    99,{ 3260,79 },{ 1248,107 },{ 215,27 },{ 3260,79 },{ 1248,107 },{ 215,27 }}, // Icelandic/Latin/Iceland
      {    52,     7,   101,{ 3339,87 },{ 3426,110 },{ 215,27 },{ 3339,87 },{ 3426,110 },{ 215,27 }}, // Indonesian/Latin/Indonesia
      {    53,     7,   260,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Interlingua/Latin/World
      {    55,    44,    38,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Inuktitut/Canadian Aboriginal/Canada
      {    55,     7,    38,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Inuktitut/Latin/Canada
      {    57,     7,   104,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Irish/Latin/Ireland
      {    57,     7,   224,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Irish/Latin/United Kingdom
      {    58,     7,   106,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Italian/Latin/Italy
      {    58,     7,   184,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Italian/Latin/San Marino
      {    58,     7,   206,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Italian/Latin/Switzerland
      {    58,     7,   230,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Italian/Latin/Vatican City State
      {    59,    19,   108,{ 3536,98 },{ 3536,98 },{ 215,27 },{ 3536,98 },{ 3536,98 },{ 215,27 }}, // Japanese/Japanese/Japan
      {    60,     7,   101,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Javanese/Latin/Indonesia
      {    61,    21,   100,{ 3634,80 },{ 3714,101 },{ 215,27 },{ 3634,80 },{ 3714,101 },{ 215,27 }}, // Kannada/Kannada/India
      {    62,     1,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kashmiri/Arabic/India
      {    62,    13,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kashmiri/Devanagari/India
      {    63,     2,   110,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kazakh/Cyrillic/Kazakhstan
      {    64,     7,   179,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kinyarwanda/Latin/Rwanda
      {    65,     2,   116,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kirghiz/Cyrillic/Kyrgyzstan
      {    66,    22,   114,{ 0,79 },{ 3815,70 },{ 215,27 },{ 0,79 },{ 3815,70 },{ 215,27 }}, // Korean/Korean/South Korea
      {    66,    22,   113,{ 0,79 },{ 3815,70 },{ 215,27 },{ 0,79 },{ 3815,70 },{ 215,27 }}, // Korean/Korean/North Korea
      {    67,     7,   217,{ 0,79 },{ 3885,110 },{ 215,27 },{ 0,79 },{ 3885,110 },{ 215,27 }}, // Kurdish/Latin/Turkey
      {    68,     7,    35,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Rundi/Latin/Burundi
      {    69,    23,   117,{ 3995,76 },{ 4071,96 },{ 215,27 },{ 4167,78 },{ 4071,96 },{ 215,27 }}, // Lao/Lao/Laos
      {    70,     7,   230,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Latin/Latin/Vatican City State
      {    71,     7,   118,{ 0,79 },{ 4245,109 },{ 215,27 },{ 0,79 },{ 4245,109 },{ 215,27 }}, // Latvian/Latin/Latvia
      {    72,     7,    49,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Lingala/Latin/Congo Kinshasa
      {    72,     7,     6,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Lingala/Latin/Angola
      {    72,     7,    41,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Lingala/Latin/Central African Republic
      {    72,     7,    50,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Lingala/Latin/Congo Brazzaville
      {    73,     7,   124,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Lithuanian/Latin/Lithuania
      {    74,     2,   127,{ 4354,72 },{ 4426,90 },{ 215,27 },{ 4354,72 },{ 4426,90 },{ 215,27 }}, // Macedonian/Cyrillic/Macedonia
      {    75,     7,   128,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Malagasy/Latin/Madagascar
      {    76,     7,   130,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Malay/Latin/Malaysia
      {    76,     1,   130,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Malay/Arabic/Malaysia
      {    76,     7,    32,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Malay/Latin/Brunei
      {    76,     7,   101,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Malay/Latin/Indonesia
      {    76,     7,   190,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Malay/Latin/Singapore
      {    77,    24,   100,{ 4516,98 },{ 4614,103 },{ 4717,27 },{ 4516,98 },{ 4744,103 },{ 4717,27 }}, // Malayalam/Malayalam/India
      {    78,     7,   133,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Maltese/Latin/Malta
      {    79,     7,   154,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Maori/Latin/New Zealand
      {    80,    13,   100,{ 4847,79 },{ 4926,88 },{ 5014,27 },{ 4847,79 },{ 4926,88 },{ 5014,27 }}, // Marathi/Devanagari/India
      {    82,     2,   143,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Mongolian/Cyrillic/Mongolia
      {    82,     8,    44,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Mongolian/Mongolian/China
      {    84,    13,   150,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Nepali/Devanagari/Nepal
      {    84,    13,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Nepali/Devanagari/India
      {    85,     7,   161,{ 5041,79 },{ 5120,107 },{ 215,27 },{ 5227,79 },{ 5120,107 },{ 215,27 }}, // Norwegian Bokmal/Latin/Norway
      {    85,     7,   203,{ 5041,79 },{ 5120,107 },{ 215,27 },{ 5227,79 },{ 5120,107 },{ 215,27 }}, // Norwegian Bokmal/Latin/Svalbard And Jan Mayen Islands
      {    86,     7,    74,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Occitan/Latin/France
      {    87,    26,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Oriya/Oriya/India
      {    88,     1,     1,{ 5306,74 },{ 5380,75 },{ 215,27 },{ 5455,74 },{ 5529,76 },{ 215,27 }}, // Pashto/Arabic/Afghanistan
      {    88,     1,   163,{ 5306,74 },{ 5605,80 },{ 215,27 },{ 5455,74 },{ 5685,81 },{ 215,27 }}, // Pashto/Arabic/Pakistan
      {    89,     1,   102,{ 5766,91 },{ 5766,91 },{ 5857,24 },{ 5881,93 },{ 5881,93 },{ 5857,24 }}, // Persian/Arabic/Iran
      {    89,     1,     1,{ 5766,91 },{ 5766,91 },{ 5857,24 },{ 5881,93 },{ 5881,93 },{ 5857,24 }}, // Persian/Arabic/Afghanistan
      {    90,     7,   172,{ 5974,78 },{ 6052,108 },{ 215,27 },{ 5974,78 },{ 6052,108 },{ 215,27 }}, // Polish/Latin/Poland
      {    91,     7,    30,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Brazil
      {    91,     7,     6,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Angola
      {    91,     7,    39,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Cape Verde
      {    91,     7,    62,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/East Timor
      {    91,     7,    66,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Equatorial Guinea
      {    91,     7,    92,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Guinea Bissau
      {    91,     7,   125,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Luxembourg
      {    91,     7,   126,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Macau
      {    91,     7,   146,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Mozambique
      {    91,     7,   173,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Portugal
      {    91,     7,   185,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Sao Tome And Principe
      {    91,     7,   206,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Portuguese/Latin/Switzerland
      {    92,     4,   100,{ 6160,78 },{ 6238,93 },{ 215,27 },{ 6160,78 },{ 6331,95 },{ 215,27 }}, // Punjabi/Gurmukhi/India
      {    92,     1,   163,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Punjabi/Arabic/Pakistan
      {    93,     7,   169,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Quechua/Latin/Peru
      {    93,     7,    26,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Quechua/Latin/Bolivia
      {    93,     7,    63,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Quechua/Latin/Ecuador
      {    94,     7,   206,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Romansh/Latin/Switzerland
      {    95,     7,   177,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Romanian/Latin/Romania
      {    95,     7,   141,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Romanian/Latin/Moldova
      {    96,     2,   178,{ 6426,80 },{ 6506,132 },{ 215,27 },{ 6426,80 },{ 6506,132 },{ 215,27 }}, // Russian/Cyrillic/Russia
      {    96,     2,    20,{ 6426,80 },{ 6506,132 },{ 215,27 },{ 6426,80 },{ 6506,132 },{ 215,27 }}, // Russian/Cyrillic/Belarus
      {    96,     2,   110,{ 6426,80 },{ 6506,132 },{ 215,27 },{ 6426,80 },{ 6506,132 },{ 215,27 }}, // Russian/Cyrillic/Kazakhstan
      {    96,     2,   116,{ 6426,80 },{ 6506,132 },{ 215,27 },{ 6426,80 },{ 6506,132 },{ 215,27 }}, // Russian/Cyrillic/Kyrgyzstan
      {    96,     2,   141,{ 6426,80 },{ 6506,132 },{ 215,27 },{ 6426,80 },{ 6506,132 },{ 215,27 }}, // Russian/Cyrillic/Moldova
      {    96,     2,   222,{ 6426,80 },{ 6506,132 },{ 215,27 },{ 6426,80 },{ 6506,132 },{ 215,27 }}, // Russian/Cyrillic/Ukraine
      {    98,     7,    41,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sango/Latin/Central African Republic
      {    99,    13,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sanskrit/Devanagari/India
      {   100,     2,   243,{ 6638,70 },{ 6708,91 },{ 215,27 },{ 6638,70 },{ 6799,98 },{ 215,27 }}, // Serbian/Cyrillic/Serbia
      {   100,     7,    27,{ 6897,73 },{ 6970,95 },{ 215,27 },{ 6897,73 },{ 7065,98 },{ 215,27 }}, // Serbian/Latin/Bosnia And Herzegowina
      {   100,     7,   242,{ 6897,73 },{ 6970,95 },{ 215,27 },{ 6897,73 },{ 7065,98 },{ 215,27 }}, // Serbian/Latin/Montenegro
      {   100,     7,   243,{ 6897,73 },{ 6970,95 },{ 215,27 },{ 6897,73 },{ 7065,98 },{ 215,27 }}, // Serbian/Latin/Serbia
      {   100,     2,    27,{ 6638,70 },{ 6708,91 },{ 215,27 },{ 6638,70 },{ 6799,98 },{ 215,27 }}, // Serbian/Cyrillic/Bosnia And Herzegowina
      {   100,     2,   242,{ 6638,70 },{ 6708,91 },{ 215,27 },{ 6638,70 },{ 6799,98 },{ 215,27 }}, // Serbian/Cyrillic/Montenegro
      {   100,     2,   257,{ 6638,70 },{ 6708,91 },{ 215,27 },{ 6638,70 },{ 6799,98 },{ 215,27 }}, // Serbian/Cyrillic/Kosovo
      {   100,     7,   257,{ 6897,73 },{ 6970,95 },{ 215,27 },{ 6897,73 },{ 7065,98 },{ 215,27 }}, // Serbian/Latin/Kosovo
      {   101,     2,    81,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Ossetic/Cyrillic/Georgia
      {   101,     2,   178,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Ossetic/Cyrillic/Russia
      {   102,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Southern Sotho/Latin/South Africa
      {   103,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tswana/Latin/South Africa
      {   104,     7,   240,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Shona/Latin/Zimbabwe
      {   105,     1,   163,{ 7163,92 },{ 7163,92 },{ 215,27 },{ 7163,92 },{ 7163,92 },{ 215,27 }}, // Sindhi/Arabic/Pakistan
      {   105,    13,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sindhi/Devanagari/India
      {   106,    32,   198,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sinhala/Sinhala/Sri Lanka
      {   107,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Swati/Latin/South Africa
      {   108,     7,   191,{ 7255,79 },{ 7334,136 },{ 215,27 },{ 7255,79 },{ 7334,136 },{ 215,27 }}, // Slovak/Latin/Slovakia
      {   109,     7,   192,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Slovenian/Latin/Slovenia
      {   110,     7,   194,{ 7470,75 },{ 7545,132 },{ 215,27 },{ 7677,79 },{ 7756,131 },{ 215,27 }}, // Somali/Latin/Somalia
      {   110,     7,    59,{ 7470,75 },{ 7545,132 },{ 215,27 },{ 7677,79 },{ 7756,131 },{ 215,27 }}, // Somali/Latin/Djibouti
      {   110,     7,    69,{ 7470,75 },{ 7545,132 },{ 215,27 },{ 7677,79 },{ 7756,131 },{ 215,27 }}, // Somali/Latin/Ethiopia
      {   110,     7,   111,{ 7470,75 },{ 7545,132 },{ 215,27 },{ 7677,79 },{ 7756,131 },{ 215,27 }}, // Somali/Latin/Kenya
      {   111,     7,   197,{ 5227,79 },{ 7887,107 },{ 215,27 },{ 5227,79 },{ 7887,107 },{ 215,27 }}, // Spanish/Latin/Spain
      {   111,     7,    10,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Argentina
      {   111,     7,    22,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Belize
      {   111,     7,    26,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Bolivia
      {   111,     7,    30,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Brazil
      {   111,     7,    43,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Chile
      {   111,     7,    47,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Colombia
      {   111,     7,    52,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Costa Rica
      {   111,     7,    55,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Cuba
      {   111,     7,    61,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Dominican Republic
      {   111,     7,    63,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Ecuador
      {   111,     7,    65,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/El Salvador
      {   111,     7,    66,{ 5227,79 },{ 7887,107 },{ 215,27 },{ 5227,79 },{ 7887,107 },{ 215,27 }}, // Spanish/Latin/Equatorial Guinea
      {   111,     7,    90,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Guatemala
      {   111,     7,    96,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Honduras
      {   111,     7,   139,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Mexico
      {   111,     7,   155,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Nicaragua
      {   111,     7,   166,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Panama
      {   111,     7,   168,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Paraguay
      {   111,     7,   169,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Peru
      {   111,     7,   170,{ 5227,79 },{ 7887,107 },{ 215,27 },{ 5227,79 },{ 7887,107 },{ 215,27 }}, // Spanish/Latin/Philippines
      {   111,     7,   174,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Puerto Rico
      {   111,     7,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/United States
      {   111,     7,   227,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Uruguay
      {   111,     7,   231,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Venezuela
      {   111,     7,   238,{ 5227,79 },{ 7887,107 },{ 215,27 },{ 5227,79 },{ 7887,107 },{ 215,27 }}, // Spanish/Latin/Canary Islands
      {   111,     7,   246,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Spanish/Latin/Latin America
      {   111,     7,   250,{ 5227,79 },{ 7887,107 },{ 215,27 },{ 5227,79 },{ 7887,107 },{ 215,27 }}, // Spanish/Latin/Ceuta And Melilla
      {   112,     7,   101,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sundanese/Latin/Indonesia
      {   113,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Swahili/Latin/Tanzania
      {   113,     7,    49,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Swahili/Latin/Congo Kinshasa
      {   113,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Swahili/Latin/Kenya
      {   113,     7,   221,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Swahili/Latin/Uganda
      {   114,     7,   205,{ 0,79 },{ 7994,128 },{ 215,27 },{ 0,79 },{ 8122,128 },{ 215,27 }}, // Swedish/Latin/Sweden
      {   114,     7,    73,{ 0,79 },{ 7994,128 },{ 215,27 },{ 0,79 },{ 8122,128 },{ 215,27 }}, // Swedish/Latin/Finland
      {   114,     7,   248,{ 0,79 },{ 7994,128 },{ 215,27 },{ 0,79 },{ 8122,128 },{ 215,27 }}, // Swedish/Latin/Aland Islands
      {   115,     7,   106,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sardinian/Latin/Italy
      {   116,     2,   209,{ 8250,75 },{ 8325,111 },{ 215,27 },{ 8250,75 },{ 8436,111 },{ 215,27 }}, // Tajik/Cyrillic/Tajikistan
      {   117,    27,   100,{ 8547,73 },{ 8620,92 },{ 215,27 },{ 8547,73 },{ 8620,92 },{ 215,27 }}, // Tamil/Tamil/India
      {   117,    27,   130,{ 8547,73 },{ 8620,92 },{ 215,27 },{ 8547,73 },{ 8620,92 },{ 215,27 }}, // Tamil/Tamil/Malaysia
      {   117,    27,   190,{ 8547,73 },{ 8620,92 },{ 215,27 },{ 8547,73 },{ 8620,92 },{ 215,27 }}, // Tamil/Tamil/Singapore
      {   117,    27,   198,{ 8547,73 },{ 8620,92 },{ 215,27 },{ 8547,73 },{ 8620,92 },{ 215,27 }}, // Tamil/Tamil/Sri Lanka
      {   118,     2,   178,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tatar/Cyrillic/Russia
      {   119,    28,   100,{ 8712,75 },{ 8787,96 },{ 215,27 },{ 8712,75 },{ 79,107 },{ 215,27 }}, // Telugu/Telugu/India
      {   120,    30,   211,{ 8883,90 },{ 8973,103 },{ 215,27 },{ 8883,90 },{ 8973,103 },{ 215,27 }}, // Thai/Thai/Thailand
      {   121,    31,    44,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tibetan/Tibetan/China
      {   121,    31,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tibetan/Tibetan/India
      {   122,    14,    69,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tigrinya/Ethiopic/Ethiopia
      {   122,    14,    67,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tigrinya/Ethiopic/Eritrea
      {   123,     7,   214,{ 9076,61 },{ 9137,100 },{ 215,27 },{ 9076,61 },{ 9137,100 },{ 215,27 }}, // Tongan/Latin/Tonga
      {   124,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tsonga/Latin/South Africa
      {   125,     7,   217,{ 9237,84 },{ 9321,111 },{ 215,27 },{ 9237,84 },{ 9321,111 },{ 215,27 }}, // Turkish/Latin/Turkey
      {   125,     7,    56,{ 9237,84 },{ 9321,111 },{ 215,27 },{ 9237,84 },{ 9321,111 },{ 215,27 }}, // Turkish/Latin/Cyprus
      {   126,     7,   218,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Turkmen/Latin/Turkmenistan
      {   128,     1,    44,{ 9432,119 },{ 9432,119 },{ 215,27 },{ 9432,119 },{ 9432,119 },{ 215,27 }}, // Uighur/Arabic/China
      {   129,     2,   222,{ 9551,72 },{ 9623,104 },{ 215,27 },{ 9727,82 },{ 9623,104 },{ 215,27 }}, // Ukrainian/Cyrillic/Ukraine
      {   130,     1,   163,{ 9809,99 },{ 9908,97 },{ 215,27 },{ 10005,97 },{ 9908,97 },{ 215,27 }}, // Urdu/Arabic/Pakistan
      {   130,     1,   100,{ 9809,99 },{ 9908,97 },{ 215,27 },{ 10005,97 },{ 9908,97 },{ 215,27 }}, // Urdu/Arabic/India
      {   131,     7,   228,{ 10102,83 },{ 10185,123 },{ 215,27 },{ 10102,83 },{ 10185,123 },{ 215,27 }}, // Uzbek/Latin/Uzbekistan
      {   131,     1,     1,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Uzbek/Arabic/Afghanistan
      {   131,     2,   228,{ 0,79 },{ 10308,115 },{ 215,27 },{ 0,79 },{ 10308,115 },{ 215,27 }}, // Uzbek/Cyrillic/Uzbekistan
      {   132,     7,   232,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Vietnamese/Latin/Vietnam
      {   133,     7,   260,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Volapuk/Latin/World
      {   134,     7,   224,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Welsh/Latin/United Kingdom
      {   135,     7,   187,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Wolof/Latin/Senegal
      {   136,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Xhosa/Latin/South Africa
      {   137,    18,   260,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Yiddish/Hebrew/World
      {   138,     7,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Yoruba/Latin/Nigeria
      {   138,     7,    23,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Yoruba/Latin/Benin
      {   140,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Zulu/Latin/South Africa
      {   141,     7,   161,{ 5041,79 },{ 5120,107 },{ 215,27 },{ 5227,79 },{ 5120,107 },{ 215,27 }}, // Norwegian Nynorsk/Latin/Norway
      {   142,     7,    27,{ 10423,75 },{ 10498,100 },{ 215,27 },{ 10423,75 },{ 10498,100 },{ 215,27 }}, // Bosnian/Latin/Bosnia And Herzegowina
      {   142,     2,    27,{ 6638,70 },{ 6708,91 },{ 215,27 },{ 6638,70 },{ 6799,98 },{ 215,27 }}, // Bosnian/Cyrillic/Bosnia And Herzegowina
      {   143,    29,   131,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Divehi/Thaana/Maldives
      {   144,     7,   251,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Manx/Latin/Isle Of Man
      {   145,     7,   224,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Cornish/Latin/United Kingdom
      {   146,     7,    83,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Akan/Latin/Ghana
      {   147,    13,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Konkani/Devanagari/India
      {   148,     7,    83,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Ga/Latin/Ghana
      {   149,     7,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Igbo/Latin/Nigeria
      {   150,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kamba/Latin/Kenya
      {   151,    33,   103,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Syriac/Syriac/Iraq
      {   152,    14,    67,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Blin/Ethiopic/Eritrea
      {   153,    14,    69,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Geez/Ethiopic/Ethiopia
      {   155,     7,    69,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sidamo/Latin/Ethiopia
      {   156,     7,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Atsam/Latin/Nigeria
      {   157,    14,    67,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tigre/Ethiopic/Eritrea
      {   158,     7,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Jju/Latin/Nigeria
      {   159,     7,   106,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Friulian/Latin/Italy
      {   160,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Venda/Latin/South Africa
      {   161,     7,    83,{ 10598,48 },{ 10646,87 },{ 215,27 },{ 10598,48 },{ 10646,87 },{ 215,27 }}, // Ewe/Latin/Ghana
      {   161,     7,   212,{ 10598,48 },{ 10646,87 },{ 215,27 },{ 10598,48 },{ 10646,87 },{ 215,27 }}, // Ewe/Latin/Togo
      {   162,    14,    69,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Walamo/Ethiopic/Ethiopia
      {   163,     7,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Hawaiian/Latin/United States
      {   164,     7,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tyap/Latin/Nigeria
      {   165,     7,   129,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Nyanja/Latin/Malawi
      {   166,     7,   170,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Filipino/Latin/Philippines
      {   167,     7,   206,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Swiss German/Latin/Switzerland
      {   167,     7,    74,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Swiss German/Latin/France
      {   167,     7,   123,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Swiss German/Latin/Liechtenstein
      {   168,    34,    44,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sichuan Yi/Yi/China
      {   169,     7,   121,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kpelle/Latin/Liberia
      {   170,     7,    82,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Low German/Latin/Germany
      {   170,     7,   151,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Low German/Latin/Netherlands
      {   171,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // South Ndebele/Latin/South Africa
      {   172,     7,   195,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Northern Sotho/Latin/South Africa
      {   173,     7,   161,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Northern Sami/Latin/Norway
      {   173,     7,    73,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Northern Sami/Latin/Finland
      {   173,     7,   205,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Northern Sami/Latin/Sweden
      {   174,     7,   208,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Taroko/Latin/Taiwan
      {   175,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Gusii/Latin/Kenya
      {   176,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Taita/Latin/Kenya
      {   177,     7,   187,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Senegal
      {   177,     7,    34,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Burkina Faso
      {   177,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Cameroon
      {   177,     7,    80,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Gambia
      {   177,     7,    83,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Ghana
      {   177,     7,    91,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Guinea
      {   177,     7,    92,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Guinea Bissau
      {   177,     7,   121,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Liberia
      {   177,     7,   136,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Mauritania
      {   177,     7,   156,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Niger
      {   177,     7,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Nigeria
      {   177,     7,   189,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Fulah/Latin/Sierra Leone
      {   178,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kikuyu/Latin/Kenya
      {   179,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Samburu/Latin/Kenya
      {   180,     7,   146,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sena/Latin/Mozambique
      {   181,     7,   240,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // North Ndebele/Latin/Zimbabwe
      {   182,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Rombo/Latin/Tanzania
      {   183,     9,   145,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tachelhit/Tifinagh/Morocco
      {   183,     7,   145,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tachelhit/Latin/Morocco
      {   184,     7,     3,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kabyle/Latin/Algeria
      {   185,     7,   221,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Nyankole/Latin/Uganda
      {   186,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Bena/Latin/Tanzania
      {   187,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Vunjo/Latin/Tanzania
      {   188,     7,   132,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Bambara/Latin/Mali
      {   188,    75,   132,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Bambara/Nko/Mali
      {   189,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Embu/Latin/Kenya
      {   190,    12,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Cherokee/Cherokee/United States
      {   191,     7,   137,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Morisyen/Latin/Mauritius
      {   192,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Makonde/Latin/Tanzania
      {   193,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Langi/Latin/Tanzania
      {   194,     7,   221,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Ganda/Latin/Uganda
      {   195,     7,   239,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Bemba/Latin/Zambia
      {   196,     7,    39,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kabuverdianu/Latin/Cape Verde
      {   197,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Meru/Latin/Kenya
      {   198,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kalenjin/Latin/Kenya
      {   199,     7,   148,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Nama/Latin/Namibia
      {   200,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Machame/Latin/Tanzania
      {   201,     7,    82,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Colognian/Latin/Germany
      {   202,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Masai/Latin/Kenya
      {   202,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Masai/Latin/Tanzania
      {   203,     7,   221,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Soga/Latin/Uganda
      {   204,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Luyia/Latin/Kenya
      {   205,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Asu/Latin/Tanzania
      {   206,     7,   221,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Teso/Latin/Uganda
      {   206,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Teso/Latin/Kenya
      {   207,     7,    67,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Saho/Latin/Eritrea
      {   208,     7,   132,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Koyra Chiini/Latin/Mali
      {   209,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Rwa/Latin/Tanzania
      {   210,     7,   111,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Luo/Latin/Kenya
      {   211,     7,   221,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Chiga/Latin/Uganda
      {   212,     7,   145,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Central Morocco Tamazight/Latin/Morocco
      {   213,     7,   132,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Koyraboro Senni/Latin/Mali
      {   214,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Shambala/Latin/Tanzania
      {   215,    13,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Bodo/Devanagari/India
      {   218,     2,   178,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Chechen/Cyrillic/Russia
      {   219,     2,   178,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Church/Cyrillic/Russia
      {   220,     2,   178,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Chuvash/Cyrillic/Russia
      {   230,     7,    49,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Luba Katanga/Latin/Congo Kinshasa
      {   231,     7,   125,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Luxembourgish/Latin/Luxembourg
      {   232,     7,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Navaho/Latin/United States
      {   236,     7,    21,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Walloon/Latin/Belgium
      {   237,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Aghem/Latin/Cameroon
      {   238,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Basaa/Latin/Cameroon
      {   239,     7,   156,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Zarma/Latin/Niger
      {   240,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Duala/Latin/Cameroon
      {   241,     7,   187,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Jola Fonyi/Latin/Senegal
      {   242,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Ewondo/Latin/Cameroon
      {   243,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Bafia/Latin/Cameroon
      {   244,     7,   146,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Makhuwa Meetto/Latin/Mozambique
      {   245,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Mundang/Latin/Cameroon
      {   246,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kwasio/Latin/Cameroon
      {   247,     7,   254,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Nuer/Latin/South Sudan
      {   248,     2,   178,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sakha/Cyrillic/Russia
      {   249,     7,   210,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sangu/Latin/Tanzania
      {   251,     7,   156,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tasawaq/Latin/Niger
      {   252,    35,   121,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Vai/Vai/Liberia
      {   252,     7,   121,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Vai/Latin/Liberia
      {   253,     7,   206,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Walser/Latin/Switzerland
      {   254,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Yangben/Latin/Cameroon
      {   256,     7,   197,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 10733,143 },{ 215,27 }}, // Asturian/Latin/Spain
      {   257,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Ngomba/Latin/Cameroon
      {   258,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kako/Latin/Cameroon
      {   259,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Meta/Latin/Cameroon
      {   260,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Ngiemboon/Latin/Cameroon
      {   261,     7,   197,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Aragonese/Latin/Spain
      {   275,    13,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Dogri/Devanagari/India
      {   290,    11,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Manipuri/Bengali/India
      {   290,    72,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Manipuri/Meitei Mayek/India
      {   304,    78,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Santali/Ol Chiki/India
      {   304,    13,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Santali/Devanagari/India
      {   309,   100,   232,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Tai Dam/Tai Viet/Vietnam
      {   312,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Akoose/Latin/Cameroon
      {   313,     7,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Lakota/Latin/United States
      {   314,     9,   145,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Standard Moroccan Tamazight/Tifinagh/Morocco
      {   315,     7,    43,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Mapuche/Latin/Chile
      {   316,     1,   103,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Central Kurdish/Arabic/Iraq
      {   316,     1,   102,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Central Kurdish/Arabic/Iran
      {   317,     7,    82,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Lower Sorbian/Latin/Germany
      {   318,     7,    82,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Upper Sorbian/Latin/Germany
      {   319,     7,    37,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kenyang/Latin/Cameroon
      {   320,     7,    38,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Mohawk/Latin/Canada
      {   321,    75,    91,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Nko/Nko/Guinea
      {   322,     7,   260,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Prussian/Latin/World
      {   323,     7,    90,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Kiche/Latin/Guatemala
      {   324,     7,   205,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Southern Sami/Latin/Sweden
      {   325,     7,   205,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Lule Sami/Latin/Sweden
      {   326,     7,    73,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Inari Sami/Latin/Finland
      {   327,     7,    73,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Skolt Sami/Latin/Finland
      {   328,     7,    13,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Warlpiri/Latin/Australia
      {   339,    13,   100,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Maithili/Devanagari/India
      {   346,     1,   102,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Mazanderani/Arabic/Iran
      {   349,     1,   102,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Northern Luri/Arabic/Iran
      {   349,     1,   103,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Northern Luri/Arabic/Iraq
      {   357,     6,    97,{ 930,72 },{ 930,72 },{ 215,27 },{ 930,72 },{ 930,72 },{ 215,27 }}, // Cantonese/Traditional Han/Hong Kong
      {   357,     5,    44,{ 10876,72 },{ 10876,72 },{ 215,27 },{ 10876,72 },{ 10876,72 },{ 215,27 }}, // Cantonese/Simplified Han/China
      {   358,   138,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Osage/Osage/United States
      {   360,     7,   260,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Ido/Latin/World
      {   361,     7,   260,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Lojban/Latin/World
      {   362,     7,   106,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Sicilian/Latin/Italy
      {   363,     1,   102,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Southern Kurdish/Arabic/Iran
      {   364,     1,   163,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Western Balochi/Arabic/Pakistan
      {   365,     7,   170,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Cebuano/Latin/Philippines
      {   366,     2,   178,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Erzya/Cyrillic/Russia
      {   367,     7,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Chickasaw/Latin/United States
      {   368,     7,   225,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Muscogee/Latin/United States
      {   369,     7,   172,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Silesian/Latin/Poland
      {   370,     7,   157,{ 0,79 },{ 79,107 },{ 215,27 },{ 0,79 },{ 79,107 },{ 215,27 }}, // Nigerian Pidgin/Latin/Nigeria
      {     0,     0,     0,{  0,0},{  0,0},{  0,0},{  0,0},{  0,0},{  0,0}}, // trailing zeros
};

static const ushort months_data[] = {
0x4d, 0x75, 0x68, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62,
0x2e, 0x20, 0x49, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x52, 0x61, 0x6a, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x2e,
0x3b, 0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x2e, 0x3b, 0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x2e, 0x3b, 0x4d,
0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20,
0x49, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b,
0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x68, 0x61, 0x2bb,
0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b,
0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x69, 0x2bb, 0x64, 0x61, 0x68, 0x3b, 0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48,
0x69, 0x6a, 0x6a, 0x61, 0x68, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b,
0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x31, 0x33, 0x31, 0x3b, 0x32, 0x3b, 0x33,
0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31,
0x32, 0x3b, 0x1219, 0x1200, 0x1228, 0x121d, 0x3b, 0x1233, 0x1348, 0x122d, 0x3b, 0x1228, 0x1262, 0x12d1, 0x120d, 0x20, 0x12a0, 0x12c8, 0x120d, 0x3b,
0x1228, 0x1262, 0x12d1, 0x120d, 0x20, 0x12a0, 0x12ba, 0x122d, 0x3b, 0x1300, 0x121b, 0x12f0, 0x120d, 0x20, 0x12a0, 0x12c8, 0x120d, 0x3b, 0x1300, 0x121b,
0x12f0, 0x120d, 0x20, 0x12a0, 0x12ba, 0x122d, 0x3b, 0x1228, 0x1300, 0x1265, 0x3b, 0x123b, 0x12a5, 0x1263, 0x1295, 0x3b, 0x1228, 0x1218, 0x12f3, 0x1295,
0x3b, 0x1238, 0x12cb, 0x120d, 0x3b, 0x12d9, 0x120d, 0x1242, 0x12f3, 0x1205, 0x3b, 0x12d9, 0x120d, 0x1202, 0x1303, 0x1205, 0x3b, 0x645, 0x62d, 0x631,
0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x3b, 0x631, 0x628, 0x64a,
0x639, 0x20, 0x627, 0x644, 0x622, 0x62e, 0x631, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x649, 0x20, 0x627, 0x644, 0x623, 0x648, 0x644, 0x649,
0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x649, 0x20, 0x627, 0x644, 0x622, 0x62e, 0x631, 0x629, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639,
0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x648, 0x20, 0x627, 0x644,
0x642, 0x639, 0x62f, 0x629, 0x3b, 0x630, 0x648, 0x20, 0x627, 0x644, 0x62d, 0x62c, 0x629, 0x3b, 0x661, 0x3b, 0x662, 0x3b, 0x663, 0x3b,
0x664, 0x3b, 0x665, 0x3b, 0x666, 0x3b, 0x667, 0x3b, 0x668, 0x3b, 0x669, 0x3b, 0x661, 0x660, 0x3b, 0x661, 0x661, 0x3b, 0x661, 0x662,
0x3b, 0x4d, 0x259, 0x68, 0x2e, 0x3b, 0x53, 0x259, 0x66, 0x2e, 0x3b, 0x52, 0x259, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x259,
0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x43, 0x259, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x43, 0x259, 0x6d, 0x2e, 0x20, 0x49, 0x49,
0x3b, 0x52, 0x259, 0x63, 0x2e, 0x3b, 0x15e, 0x61, 0x62, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x15e, 0x259, 0x76, 0x2e,
0x3b, 0x5a, 0x69, 0x6c, 0x71, 0x2e, 0x3b, 0x5a, 0x69, 0x6c, 0x68, 0x2e, 0x3b, 0x4d, 0x259, 0x68, 0x259, 0x72, 0x72, 0x259,
0x6d, 0x3b, 0x53, 0x259, 0x66, 0x259, 0x72, 0x3b, 0x52, 0x259, 0x62, 0x69, 0xfc, 0x6c, 0x259, 0x76, 0x76, 0x259, 0x6c, 0x3b,
0x52, 0x259, 0x62, 0x69, 0xfc, 0x6c, 0x61, 0x78, 0x131, 0x72, 0x3b, 0x43, 0x259, 0x6d, 0x61, 0x64, 0x69, 0x79, 0x259, 0x6c,
0x259, 0x76, 0x76, 0x259, 0x6c, 0x3b, 0x43, 0x259, 0x6d, 0x61, 0x64, 0x69, 0x79, 0x259, 0x6c, 0x61, 0x78, 0x131, 0x72, 0x3b,
0x52, 0x259, 0x63, 0x259, 0x62, 0x3b, 0x15e, 0x61, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x7a, 0x61, 0x6e, 0x3b,
0x15e, 0x259, 0x76, 0x76, 0x61, 0x6c, 0x3b, 0x5a, 0x69, 0x6c, 0x71, 0x259, 0x64, 0x259, 0x3b, 0x5a, 0x69, 0x6c, 0x68, 0x69,
0x63, 0x63, 0x259, 0x3b, 0x9ae, 0x9b9, 0x9b0, 0x9b0, 0x9ae, 0x3b, 0x9b8, 0x9ab, 0x9b0, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x989, 0x9b2, 0x20,
0x986, 0x989, 0x9af, 0x9bc, 0x9be, 0x9b2, 0x3b, 0x9b0, 0x9ac, 0x9bf, 0x989, 0x9b8, 0x20, 0x9b8, 0x9be, 0x9a8, 0x9bf, 0x3b, 0x99c, 0x9ae,
0x9be, 0x9a6, 0x9bf, 0x989, 0x9b2, 0x20, 0x986, 0x989, 0x9af, 0x9bc, 0x9be, 0x9b2, 0x3b, 0x99c, 0x9ae, 0x9be, 0x9a6, 0x9bf, 0x989, 0x9b8,
0x20, 0x9b8, 0x9be, 0x9a8, 0x9bf, 0x3b, 0x9b0, 0x99c, 0x9ac, 0x3b, 0x9b6, 0x9be, 0x2018, 0x9ac, 0x9be, 0x9a8, 0x3b, 0x9b0, 0x9ae, 0x99c,
0x9be, 0x9a8, 0x3b, 0x9b6, 0x9be, 0x993, 0x9af, 0x9bc, 0x9be, 0x9b2, 0x3b, 0x99c, 0x9cd, 0x9ac, 0x9bf, 0x9b2, 0x995, 0x9a6, 0x3b, 0x99c,
0x9cd, 0x9ac, 0x9bf, 0x9b2, 0x9b9, 0x99c, 0x9cd, 0x99c, 0x3b, 0x9e7, 0x3b, 0x9e8, 0x3b, 0x9e9, 0x3b, 0x9ea, 0x3b, 0x9eb, 0x3b, 0x9ec,
0x3b, 0x9ed, 0x3b, 0x9ee, 0x3b, 0x9ef, 0x3b, 0x9e7, 0x9e6, 0x3b, 0x9e7, 0x9e7, 0x3b, 0x9e7, 0x9e8, 0x3b, 0x43c, 0x443, 0x445, 0x430,
0x440, 0x430, 0x43c, 0x3b, 0x441, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x440, 0x430, 0x431, 0x438, 0x2d, 0x31, 0x3b, 0x440, 0x430, 0x431,
0x438, 0x2d, 0x32, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430, 0x434, 0x430, 0x2d, 0x31, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430, 0x434,
0x430, 0x2d, 0x32, 0x3b, 0x440, 0x430, 0x434, 0x436, 0x430, 0x431, 0x3b, 0x448, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x440, 0x430, 0x43c,
0x430, 0x437, 0x430, 0x43d, 0x3b, 0x428, 0x430, 0x432, 0x430, 0x43b, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d, 0x41a, 0x430, 0x430, 0x434,
0x430, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d, 0x445, 0x438, 0x434, 0x436, 0x430, 0x3b, 0x31, 0x6708, 0x3b, 0x32, 0x6708, 0x3b, 0x33,
0x6708, 0x3b, 0x34, 0x6708, 0x3b, 0x35, 0x6708, 0x3b, 0x36, 0x6708, 0x3b, 0x37, 0x6708, 0x3b, 0x38, 0x6708, 0x3b, 0x39, 0x6708, 0x3b,
0x31, 0x30, 0x6708, 0x3b, 0x31, 0x31, 0x6708, 0x3b, 0x31, 0x32, 0x6708, 0x3b, 0x4e00, 0x6708, 0x3b, 0x4e8c, 0x6708, 0x3b, 0x4e09, 0x6708,
0x3b, 0x56db, 0x6708, 0x3b, 0x4e94, 0x6708, 0x3b, 0x516d, 0x6708, 0x3b, 0x4e03, 0x6708, 0x3b, 0x516b, 0x6708, 0x3b, 0x4e5d, 0x6708, 0x3b, 0x5341,
0x6708, 0x3b, 0x5341, 0x4e00, 0x6708, 0x3b, 0x5341, 0x4e8c, 0x6708, 0x3b, 0x7a46, 0x54c8, 0x862d, 0x59c6, 0x6708, 0x3b, 0x8272, 0x6cd5, 0x723e, 0x6708,
0x3b, 0x8cf4, 0x6bd4, 0x6708, 0x20, 0x49, 0x3b, 0x8cf4, 0x6bd4, 0x6708, 0x20, 0x49, 0x49, 0x3b, 0x4e3b, 0x99ac, 0x9054, 0x6708, 0x20, 0x49,
0x3b, 0x4e3b, 0x99ac, 0x9054, 0x6708, 0x20, 0x49, 0x49, 0x3b, 0x8cf4, 0x54f2, 0x535c, 0x6708, 0x3b, 0x820d, 0x723e, 0x90a6, 0x6708, 0x3b, 0x8cf4,
0x8cb7, 0x4e39, 0x6708, 0x3b, 0x9583, 0x74e6, 0x9b6f, 0x6708, 0x3b, 0x90fd, 0x723e, 0x5580, 0x723e, 0x5fb7, 0x6708, 0x3b, 0x90fd, 0x723e, 0x9ed1, 0x54f2,
0x6708, 0x3b, 0x31, 0x2e, 0x3b, 0x32, 0x2e, 0x3b, 0x33, 0x2e, 0x3b, 0x34, 0x2e, 0x3b, 0x35, 0x2e, 0x3b, 0x36, 0x2e, 0x3b,
0x37, 0x2e, 0x3b, 0x38, 0x2e, 0x3b, 0x39, 0x2e, 0x3b, 0x31, 0x30, 0x2e, 0x3b, 0x31, 0x31, 0x2e, 0x3b, 0x31, 0x32, 0x2e,
0x3b, 0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x65, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x72, 0x65,
0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x2e, 0x20,
0x49, 0x49, 0x3b, 0x72, 0x65, 0x64, 0x2e, 0x3b, 0x161, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x161, 0x61, 0x77,
0x2e, 0x3b, 0x7a, 0xfa, 0x20, 0x6c, 0x2d, 0x6b, 0x2e, 0x3b, 0x7a, 0xfa, 0x20, 0x6c, 0x2d, 0x68, 0x2e, 0x3b, 0x6d, 0x75,
0x68, 0x61, 0x72, 0x72, 0x65, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x65, 0x62, 0xed, 0x2019, 0x75, 0x20,
0x6c, 0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x72, 0x65, 0x62, 0xed, 0x2019, 0x75, 0x20, 0x73, 0x2d, 0x73, 0xe1, 0x6e,
0xed, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0xe1, 0x64, 0xe1, 0x20, 0x61, 0x6c, 0x2d, 0xfa, 0x6c, 0xe1, 0x3b, 0x64, 0x17e, 0x75,
0x6d, 0xe1, 0x64, 0xe1, 0x20, 0x61, 0x6c, 0x2d, 0xe1, 0x63, 0x68, 0x69, 0x72, 0x61, 0x3b, 0x72, 0x65, 0x64, 0x17e, 0x65,
0x62, 0x3b, 0x161, 0x61, 0x2019, 0x62, 0xe1, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0xe1, 0x6e, 0x3b, 0x161, 0x61, 0x77,
0x77, 0x61, 0x6c, 0x3b, 0x7a, 0xfa, 0x20, 0x6c, 0x2d, 0x6b, 0x61, 0x2019, 0x64, 0x61, 0x3b, 0x7a, 0xfa, 0x20, 0x6c, 0x2d,
0x68, 0x69, 0x64, 0x17e, 0x64, 0x17e, 0x61, 0x3b, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66,
0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b,
0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x72,
0x61, 0x6a, 0x61, 0x62, 0x3b, 0x73, 0x68, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e,
0x3b, 0x73, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x69, 0x2bb, 0x64, 0x61,
0x68, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x3b, 0x4d, 0x6f, 0x65, 0x68, 0x2e,
0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49,
0x3b, 0x4a, 0x6f, 0x65, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x4a, 0x6f, 0x65, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61,
0x6a, 0x2e, 0x3b, 0x53, 0x6a, 0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x6a, 0x61, 0x77, 0x2e, 0x3b, 0x44,
0x6f, 0x65, 0x20, 0x61, 0x6c, 0x20, 0x6b, 0x2e, 0x3b, 0x44, 0x6f, 0x65, 0x20, 0x61, 0x6c, 0x20, 0x68, 0x2e, 0x3b, 0x4d,
0x6f, 0x65, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb,
0x61, 0x20, 0x61, 0x6c, 0x20, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x61, 0x20, 0x61, 0x6c, 0x20,
0x74, 0x68, 0x61, 0x6e, 0x69, 0x3b, 0x4a, 0x6f, 0x65, 0x6d, 0x61, 0x64, 0x2bb, 0x61, 0x6c, 0x20, 0x61, 0x77, 0x61, 0x6c,
0x3b, 0x4a, 0x6f, 0x65, 0x6d, 0x61, 0x64, 0x2bb, 0x61, 0x6c, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x69, 0x3b, 0x52, 0x61, 0x6a,
0x61, 0x62, 0x3b, 0x53, 0x6a, 0x61, 0x2bb, 0x61, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b,
0x53, 0x6a, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x44, 0x6f, 0x65, 0x20, 0x61, 0x6c, 0x20, 0x6b, 0x61, 0x2bb, 0x61, 0x62, 0x61,
0x3b, 0x44, 0x6f, 0x65, 0x20, 0x61, 0x6c, 0x20, 0x68, 0x69, 0x7a, 0x6a, 0x61, 0x3b, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72,
0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2019, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x77,
0x77, 0x61, 0x6c, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2019, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x64,
0x17e, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c, 0x2d, 0x75, 0x6c, 0x61, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x61, 0x64, 0x61,
0x2d, 0x6c, 0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x61, 0x3b, 0x72, 0x61, 0x64, 0x17e, 0x61, 0x62, 0x3b, 0x161, 0x61, 0x2019,
0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x161, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64,
0x68, 0x75, 0x2d, 0x6c, 0x2d, 0x71, 0x61, 0x2019, 0x64, 0x61, 0x3b, 0x64, 0x68, 0x75, 0x2d, 0x6c, 0x2d, 0x68, 0x69, 0x64,
0x64, 0x17e, 0x61, 0x3b, 0x6d, 0x6f, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20,
0x61, 0x77, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x74, 0x68, 0x2e, 0x3b, 0x6a, 0x6f, 0x75, 0x6d, 0x2e, 0x20, 0x6f,
0x75, 0x2e, 0x3b, 0x6a, 0x6f, 0x75, 0x6d, 0x2e, 0x20, 0x74, 0x68, 0x2e, 0x3b, 0x72, 0x61, 0x6a, 0x2e, 0x3b, 0x63, 0x68,
0x61, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x63, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x64, 0x68, 0x6f, 0x75, 0x2e,
0x20, 0x71, 0x69, 0x2e, 0x3b, 0x64, 0x68, 0x6f, 0x75, 0x2e, 0x20, 0x68, 0x69, 0x2e, 0x3b, 0x6d, 0x6f, 0x75, 0x68, 0x61,
0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x61, 0x20, 0x61, 0x6c, 0x20,
0x61, 0x77, 0x61, 0x6c, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x61, 0x20, 0x61, 0x74, 0x68, 0x2d, 0x74, 0x68, 0x61, 0x6e, 0x69,
0x3b, 0x6a, 0x6f, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x61, 0x6c, 0x20, 0x6f, 0x75, 0x6c, 0x61, 0x3b, 0x6a, 0x6f, 0x75,
0x6d, 0x61, 0x64, 0x61, 0x20, 0x61, 0x74, 0x68, 0x2d, 0x74, 0x68, 0x61, 0x6e, 0x69, 0x61, 0x3b, 0x72, 0x61, 0x6a, 0x61,
0x62, 0x3b, 0x63, 0x68, 0x61, 0x61, 0x62, 0x61, 0x6e, 0x65, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x63,
0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x6f, 0x75, 0x20, 0x61, 0x6c, 0x20, 0x71, 0x69, 0x60, 0x64, 0x61,
0x3b, 0x64, 0x68, 0x6f, 0x75, 0x20, 0x61, 0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a, 0x61, 0x3b, 0x6d, 0x6f, 0x75, 0x68, 0x2e,
0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x61, 0x77, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20,
0x74, 0x68, 0x2e, 0x3b, 0x6a, 0x6f, 0x75, 0x6d, 0x2e, 0x20, 0x6f, 0x75, 0x6c, 0x2e, 0x3b, 0x6a, 0x6f, 0x75, 0x6d, 0x2e,
0x20, 0x74, 0x68, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6a, 0x2e, 0x3b, 0x63, 0x68, 0x61, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d,
0x2e, 0x3b, 0x63, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x64, 0x68, 0x6f, 0x75, 0x2e, 0x20, 0x71, 0x2e, 0x3b, 0x64, 0x68, 0x6f,
0x75, 0x2e, 0x20, 0x68, 0x2e, 0x3b, 0x10db, 0x10e3, 0x10f0, 0x2e, 0x3b, 0x10e1, 0x10d0, 0x10e4, 0x2e, 0x3b, 0x10e0, 0x10d0, 0x10d1, 0x2e,
0x20, 0x49, 0x3b, 0x10e0, 0x10d0, 0x10d1, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x10ef, 0x10e3, 0x10db, 0x2e, 0x20, 0x49, 0x3b, 0x10ef, 0x10e3,
0x10db, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x10e0, 0x10d0, 0x10ef, 0x2e, 0x3b, 0x10e8, 0x10d0, 0x10d1, 0x2e, 0x3b, 0x10e0, 0x10d0, 0x10db, 0x2e,
0x3b, 0x10e8, 0x10d0, 0x10d5, 0x2e, 0x3b, 0x10d6, 0x10e3, 0x10da, 0x2d, 0x10d9, 0x2e, 0x3b, 0x10d6, 0x10e3, 0x10da, 0x2d, 0x10f0, 0x2e, 0x3b,
0x10db, 0x10e3, 0x10f0, 0x10d0, 0x10e0, 0x10d0, 0x10db, 0x10d8, 0x3b, 0x10e1, 0x10d0, 0x10e4, 0x10d0, 0x10e0, 0x10d8, 0x3b, 0x10e0, 0x10d0, 0x10d1, 0x10d8,
0x20, 0x10e3, 0x10da, 0x2d, 0x10d0, 0x10d5, 0x10d0, 0x10da, 0x10d8, 0x3b, 0x10e0, 0x10d0, 0x10d1, 0x10d8, 0x20, 0x10e3, 0x10da, 0x2d, 0x10d0, 0x10ee,
0x10d8, 0x10e0, 0x10d8, 0x3b, 0x10ef, 0x10e3, 0x10db, 0x10d0, 0x10d3, 0x10d0, 0x20, 0x10e3, 0x10da, 0x2d, 0x10d0, 0x10d5, 0x10d0, 0x10da, 0x10d8, 0x3b,
0x10ef, 0x10e3, 0x10db, 0x10d0, 0x10d3, 0x10d0, 0x20, 0x10e3, 0x10da, 0x2d, 0x10d0, 0x10ee, 0x10d8, 0x10e0, 0x10d8, 0x3b, 0x10e0, 0x10d0, 0x10ef, 0x10d0,
0x10d1, 0x10d8, 0x3b, 0x10e8, 0x10d0, 0x10d1, 0x10d0, 0x10dc, 0x10d8, 0x3b, 0x10e0, 0x10d0, 0x10db, 0x10d0, 0x10d3, 0x10d0, 0x10dc, 0x10d8, 0x3b, 0x10e8,
0x10d0, 0x10d5, 0x10d0, 0x10da, 0x10d8, 0x3b, 0x10d6, 0x10e3, 0x10da, 0x2d, 0x10d9, 0x10d0, 0x10d0, 0x10d3, 0x10d0, 0x3b, 0x10d6, 0x10e3, 0x10da, 0x2d,
0x10f0, 0x10d8, 0x10ef, 0x10d0, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b,
0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x44, 0x73, 0x63,
0x68, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x44, 0x73, 0x63, 0x68, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49,
0x49, 0x3b, 0x52, 0x61, 0x64, 0x73, 0x63, 0x68, 0x61, 0x62, 0x3b, 0x53, 0x68, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x52,
0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x44, 0x68, 0x75, 0x20, 0x6c,
0x2d, 0x71, 0x61, 0x2bf, 0x64, 0x61, 0x3b, 0x44, 0x68, 0x75, 0x20, 0x6c, 0x2d, 0x48, 0x69, 0x64, 0x64, 0x73, 0x63, 0x68,
0x61, 0x3b, 0xaae, 0xac1, 0xab9, 0x2e, 0x3b, 0xab8, 0xaab, 0x2e, 0x3b, 0xab0, 0xaac, 0x2e, 0x49, 0x3b, 0xab0, 0xaac, 0x2e, 0x20,
0x49, 0x49, 0x3b, 0xa9c, 0xac1, 0xaae, 0x2e, 0x20, 0x49, 0x3b, 0xa9c, 0xac1, 0xaae, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0xab0, 0xabe,
0xa9c, 0x2e, 0x3b, 0xab6, 0xabe, 0x2e, 0x3b, 0xab0, 0xabe, 0xaae, 0x2e, 0x3b, 0xab6, 0xabe, 0xab5, 0x2e, 0x3b, 0xaa7, 0xac1, 0x2bb,
0xab2, 0x2d, 0xa95, 0xacd, 0xaaf, 0xac1, 0x2e, 0x3b, 0xaa7, 0xac1, 0x2bb, 0xab2, 0x2d, 0xa8f, 0xa9a, 0x2e, 0x3b, 0xaae, 0xac1, 0xab9,
0xab0, 0xacd, 0xab0, 0xaae, 0x3b, 0xab8, 0xaab, 0xab0, 0x3b, 0xab0, 0xabe, 0xaac, 0xac0, 0x2bb, 0x20, 0x49, 0x3b, 0xab0, 0xabe, 0xaac,
0xac0, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0xa9c, 0xac1, 0xaae, 0xabe, 0xaa6, 0xabe, 0x20, 0x49, 0x3b, 0xa9c, 0xac1, 0xaae, 0xabe, 0xaa6,
0xabe, 0x20, 0x49, 0x49, 0x3b, 0xab0, 0xa9c, 0xaac, 0x3b, 0xab6, 0xabe, 0x2bb, 0xaac, 0xabe, 0xaa8, 0x3b, 0xab0, 0xaae, 0xaa6, 0xabe,
0xaa8, 0x3b, 0xab6, 0xabe, 0xab5, 0xacd, 0xab5, 0xab2, 0x3b, 0xaa7, 0xac1, 0x2bb, 0xab2, 0x2d, 0xa95, 0xacd, 0xab5, 0xac0, 0x2bb, 0xaa1,
0xabe, 0xab9, 0x3b, 0xaa7, 0xac1, 0x2bb, 0xab2, 0x2d, 0xab9, 0xabf, 0xa9c, 0xacd, 0xa9c, 0xabe, 0xab9, 0x3b, 0x5de, 0x5d5, 0x5d7, 0x5e8,
0x5dd, 0x3b, 0x5e6, 0x5e4, 0x5e8, 0x3b, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d0, 0x5f3, 0x3b, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d1,
0x5f3, 0x3b, 0x5d2, 0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0, 0x20, 0x5d0, 0x5f3, 0x3b, 0x5d2, 0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0,
0x20, 0x5d1, 0x5f3, 0x3b, 0x5e8, 0x5d2, 0x5f3, 0x5d1, 0x3b, 0x5e9, 0x5e2, 0x5d1, 0x5d0, 0x5df, 0x3b, 0x5e8, 0x5de, 0x5d3, 0x5d0, 0x5df,
0x3b, 0x5e9, 0x5d5, 0x5d5, 0x5d0, 0x5dc, 0x3b, 0x5d3, 0x5f3, 0x5d5, 0x20, 0x5d0, 0x5dc, 0x5be, 0x5e7, 0x5e2, 0x5d3, 0x5d4, 0x3b, 0x5d3,
0x5f3, 0x5d5, 0x20, 0x5d0, 0x5dc, 0x5be, 0x5d7, 0x5d9, 0x5d2, 0x5f3, 0x5d4, 0x3b, 0x5de, 0x5d5, 0x5d7, 0x5e8, 0x5dd, 0x3b, 0x5e6, 0x5e4,
0x5e8, 0x3b, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d0, 0x5dc, 0x5be, 0x5d0, 0x5d5, 0x5d5, 0x5dc, 0x3b, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20,
0x5d0, 0x5be, 0x5ea, 0x5f3, 0x5d0, 0x5e0, 0x5d9, 0x3b, 0x5d2, 0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0, 0x20, 0x5d0, 0x5dc, 0x5be, 0x5d0,
0x5d5, 0x5dc, 0x5d0, 0x3b, 0x5d2, 0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0, 0x20, 0x5d0, 0x5be, 0x5ea, 0x5f3, 0x5d0, 0x5e0, 0x5d9, 0x5d4,
0x3b, 0x5e8, 0x5d2, 0x5f3, 0x5d1, 0x3b, 0x5e9, 0x5e2, 0x5d1, 0x5d0, 0x5df, 0x3b, 0x5e8, 0x5de, 0x5d3, 0x5d0, 0x5df, 0x3b, 0x5e9, 0x5d5,
0x5d5, 0x5d0, 0x5dc, 0x3b, 0x5d3, 0x5f3, 0x5d5, 0x20, 0x5d0, 0x5dc, 0x5be, 0x5e7, 0x5e2, 0x5d3, 0x5d4, 0x3b, 0x5d3, 0x5f3, 0x5d5, 0x20,
0x5d0, 0x5dc, 0x5be, 0x5d7, 0x5d9, 0x5d2, 0x5f3, 0x5d4, 0x3b, 0x5de, 0x5d5, 0x5d7, 0x5e8, 0x5dd, 0x3b, 0x5e6, 0x5e4, 0x5e8, 0x3b, 0x5e8,
0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d0, 0x5dc, 0x2d, 0x5d0, 0x5d5, 0x5d5, 0x5dc, 0x3b, 0x5e8, 0x5d1, 0x5d9, 0x5e2, 0x20, 0x5d0, 0x2d, 0x5ea,
0x5f3, 0x5d0, 0x5e0, 0x5d9, 0x3b, 0x5d2, 0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0, 0x20, 0x5d0, 0x5dc, 0x2d, 0x5d0, 0x5d5, 0x5dc, 0x5d0,
0x3b, 0x5d2, 0x5f3, 0x5d5, 0x5de, 0x5d0, 0x5d3, 0x5d0, 0x20, 0x5d0, 0x2d, 0x5ea, 0x5f3, 0x5d0, 0x5e0, 0x5d9, 0x5d4, 0x3b, 0x5e8, 0x5d2,
0x5f3, 0x5d1, 0x3b, 0x5e9, 0x5e2, 0x5d1, 0x5d0, 0x5df, 0x3b, 0x5e8, 0x5de, 0x5d3, 0x5d0, 0x5df, 0x3b, 0x5e9, 0x5d5, 0x5d5, 0x5d0, 0x5dc,
0x3b, 0x5d3, 0x5f3, 0x5d5, 0x20, 0x5d0, 0x5dc, 0x5be, 0x5e7, 0x5e2, 0x5d3, 0x5d4, 0x3b, 0x5d3, 0x5f3, 0x5d5, 0x20, 0x5d0, 0x5dc, 0x5be,
0x5d7, 0x5d9, 0x5d2, 0x5f3, 0x5d4, 0x3b, 0x92e, 0x941, 0x939, 0x930, 0x94d, 0x930, 0x92e, 0x3b, 0x938, 0x92b, 0x930, 0x3b, 0x930, 0x93e,
0x92c, 0x940, 0x20, 0x92a, 0x94d, 0x930, 0x925, 0x92e, 0x3b, 0x930, 0x93e, 0x92c, 0x940, 0x20, 0x926, 0x94d, 0x935, 0x93f, 0x924, 0x940,
0x92f, 0x3b, 0x91c, 0x941, 0x92e, 0x94d, 0x921, 0x93e, 0x20, 0x92a, 0x94d, 0x930, 0x925, 0x92e, 0x3b, 0x91c, 0x941, 0x92e, 0x94d, 0x921,
0x93e, 0x20, 0x926, 0x94d, 0x935, 0x93f, 0x924, 0x940, 0x92f, 0x3b, 0x930, 0x91c, 0x92c, 0x3b, 0x936, 0x93e, 0x935, 0x928, 0x3b, 0x930,
0x92e, 0x91c, 0x93e, 0x928, 0x3b, 0x936, 0x935, 0x94d, 0x935, 0x94d, 0x932, 0x3b, 0x91c, 0x93f, 0x932, 0x2d, 0x915, 0x94d, 0x926, 0x93e,
0x939, 0x3b, 0x91c, 0x93f, 0x932, 0x94d, 0x2d, 0x939, 0x93f, 0x91c, 0x94d, 0x91c, 0x93e, 0x939, 0x3b, 0x4d, 0x6f, 0x68, 0x2e, 0x3b,
0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0xe9, 0x62, 0x2e, 0x20, 0x31, 0x3b, 0x52, 0xe9, 0x62, 0x2e, 0x20, 0x32, 0x3b, 0x44,
0x73, 0x65, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x44, 0x73, 0x65, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x65, 0x64, 0x2e,
0x3b, 0x53, 0x61, 0x62, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x65, 0x76, 0x2e, 0x3b, 0x44, 0x73, 0xfc, 0x6c,
0x20, 0x6b, 0x2e, 0x3b, 0x44, 0x73, 0xfc, 0x6c, 0x20, 0x68, 0x2e, 0x3b, 0x4d, 0x6f, 0x68, 0x61, 0x72, 0x72, 0x65, 0x6d,
0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0xe9, 0x62, 0x69, 0x20, 0x49, 0x3b, 0x52, 0xe9, 0x62, 0x69, 0x20, 0x49,
0x49, 0x3b, 0x44, 0x73, 0x65, 0x6d, 0xe1, 0x64, 0x69, 0x20, 0x49, 0x3b, 0x44, 0x73, 0x65, 0x6d, 0xe1, 0x64, 0x69, 0x20,
0x49, 0x49, 0x3b, 0x52, 0x65, 0x64, 0x73, 0x65, 0x62, 0x3b, 0x53, 0x61, 0x62, 0xe1, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61,
0x64, 0xe1, 0x6e, 0x3b, 0x53, 0x65, 0x76, 0x76, 0xe1, 0x6c, 0x3b, 0x44, 0x73, 0xfc, 0x6c, 0x20, 0x6b, 0x61, 0x64, 0x65,
0x3b, 0x44, 0x73, 0xfc, 0x6c, 0x20, 0x68, 0x65, 0x64, 0x73, 0x65, 0x3b, 0x4d, 0x6f, 0x68, 0x61, 0x72, 0x72, 0x65, 0x6d,
0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0xe9, 0x62, 0x69, 0x20, 0x65, 0x6c, 0x20, 0x61, 0x76, 0x76, 0x65, 0x6c,
0x3b, 0x52, 0xe9, 0x62, 0x69, 0x20, 0x65, 0x6c, 0x20, 0x61, 0x63, 0x63, 0x68, 0x65, 0x72, 0x3b, 0x44, 0x73, 0x65, 0x6d,
0xe1, 0x64, 0x69, 0x20, 0x65, 0x6c, 0x20, 0x61, 0x76, 0x76, 0x65, 0x6c, 0x3b, 0x44, 0x73, 0x65, 0x6d, 0xe1, 0x64, 0x69,
0x20, 0x65, 0x6c, 0x20, 0x61, 0x63, 0x63, 0x68, 0x65, 0x72, 0x3b, 0x52, 0x65, 0x64, 0x73, 0x65, 0x62, 0x3b, 0x53, 0x61,
0x62, 0xe1, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0xe1, 0x6e, 0x3b, 0x53, 0x65, 0x76, 0x76, 0xe1, 0x6c, 0x3b, 0x44,
0x73, 0xfc, 0x6c, 0x20, 0x6b, 0x61, 0x64, 0x65, 0x3b, 0x44, 0x73, 0xfc, 0x6c, 0x20, 0x68, 0x65, 0x64, 0x73, 0x65, 0x3b,
0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x72, 0x61, 0x62,
0x2e, 0x20, 0x49, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x72, 0x61, 0x6a, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x77, 0x2e,
0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x2e, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x2e, 0x3b, 0x4d,
0x75, 0x68, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x41, 0x77, 0x61, 0x6c, 0x3b, 0x52,
0x61, 0x62, 0x2e, 0x20, 0x41, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x41, 0x77, 0x61, 0x6c, 0x3b,
0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x41, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x52, 0x61, 0x6a, 0x2e, 0x3b, 0x53, 0x79, 0x61, 0x2e,
0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x79, 0x61, 0x77, 0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x6b, 0x61, 0x2e, 0x3b, 0x5a,
0x75, 0x6c, 0x68, 0x69, 0x2e, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b,
0x52, 0x61, 0x62, 0x69, 0x75, 0x6c, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x75, 0x6c, 0x61, 0x6b, 0x68,
0x69, 0x72, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x69, 0x6c, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64,
0x69, 0x6c, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x79, 0x61, 0x6b, 0x62, 0x61,
0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x79, 0x61, 0x77, 0x61, 0x6c, 0x3b, 0x5a, 0x75, 0x6c,
0x6b, 0x61, 0x69, 0x64, 0x61, 0x68, 0x3b, 0x5a, 0x75, 0x6c, 0x68, 0x69, 0x6a, 0x61, 0x68, 0x3b, 0x30e0, 0x30cf, 0x30c3, 0x30e9,
0x30e0, 0x3b, 0x30b5, 0x30d5, 0x30a2, 0x30eb, 0x3b, 0x30e9, 0x30d3, 0x30fc, 0x30fb, 0x30a6, 0x30eb, 0x30fb, 0x30a2, 0x30a6, 0x30ef, 0x30eb, 0x3b, 0x30e9,
0x30d3, 0x30fc, 0x30fb, 0x30a6, 0x30c3, 0x30fb, 0x30b5, 0x30fc, 0x30cb, 0x30fc, 0x3b, 0x30b8, 0x30e5, 0x30de, 0x30fc, 0x30c0, 0x30eb, 0x30fb, 0x30a2, 0x30a6,
0x30ef, 0x30eb, 0x3b, 0x30b8, 0x30e5, 0x30de, 0x30fc, 0x30c0, 0x30c3, 0x30b5, 0x30fc, 0x30cb, 0x30fc, 0x3b, 0x30e9, 0x30b8, 0x30e3, 0x30d6, 0x3b, 0x30b7,
0x30e3, 0x30a2, 0x30d0, 0x30fc, 0x30f3, 0x3b, 0x30e9, 0x30de, 0x30c0, 0x30fc, 0x30f3, 0x3b, 0x30b7, 0x30e3, 0x30a6, 0x30ef, 0x30fc, 0x30eb, 0x3b, 0x30ba,
0x30eb, 0x30fb, 0x30ab, 0x30a4, 0x30c0, 0x3b, 0x30ba, 0x30eb, 0x30fb, 0x30d2, 0x30c3, 0x30b8, 0x30e3, 0x3b, 0xcae, 0xcc1, 0xcb9, 0xccd, 0x2e, 0x3b,
0xcb8, 0xcab, 0xcbe, 0x2e, 0x3b, 0xcb0, 0xcac, 0xcbf, 0x2018, 0x20, 0x49, 0x3b, 0xcb0, 0xcac, 0xcbf, 0x2018, 0x20, 0x49, 0x49, 0x3b,
0xc9c, 0xcc1, 0xcae, 0xccd, 0x2e, 0x20, 0x49, 0x3b, 0xc9c, 0xcc1, 0xcae, 0xccd, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0xcb0, 0xc9c, 0xccd,
0x2e, 0x3b, 0xcb6, 0x2e, 0x3b, 0xcb0, 0xcae, 0xccd, 0x2e, 0x3b, 0xcb6, 0xcb5, 0xccd, 0x2e, 0x3b, 0xca7, 0xcc1, 0x2018, 0xcb2, 0xccd,
0x2d, 0xc95, 0xcbf, 0x2e, 0x3b, 0xca7, 0xcc1, 0x2018, 0xcb2, 0xccd, 0x2d, 0xcb9, 0x2e, 0x3b, 0xcae, 0xcc1, 0xcb9, 0xcb0, 0xcae, 0xccd,
0x3b, 0xcb8, 0xcab, 0xcbe, 0xcb0, 0xccd, 0x3b, 0xcb0, 0xcac, 0xcbf, 0x2018, 0x20, 0x49, 0x3b, 0xcb0, 0xcac, 0xcbf, 0x2018, 0x20, 0x49,
0x49, 0x3b, 0xc9c, 0xcc1, 0xcae, 0xcbe, 0xca6, 0xcbe, 0x20, 0x49, 0x3b, 0xc9c, 0xcc1, 0xcae, 0xcbe, 0xca6, 0xcbe, 0x20, 0x49, 0x49,
0x3b, 0xcb0, 0xc9c, 0xcac, 0xccd, 0x3b, 0xcb6, 0x2019, 0xcac, 0xcbe, 0xca8, 0xccd, 0x3b, 0xcb0, 0xcae, 0xca6, 0xcbe, 0xca8, 0xccd, 0x3b,
0xcb6, 0xcb5, 0xccd, 0xcb5, 0xcbe, 0xcb2, 0xccd, 0x3b, 0xca7, 0xcc1, 0x2018, 0xcb2, 0xccd, 0x2d, 0xc95, 0xcbf, 0x2018, 0xca1, 0xcbe, 0xcb9,
0xccd, 0x3b, 0xca7, 0xcc1, 0x2018, 0xcb2, 0xccd, 0x2d, 0xcb9, 0xcbf, 0xc9c, 0xcbe, 0xcb9, 0xccd, 0x3b, 0xbb34, 0xd558, 0xb78c, 0x3b, 0xc0ac,
0xd30c, 0xb974, 0x3b, 0xb77c, 0xbe44, 0x20, 0xc54c, 0x20, 0xc544, 0xc648, 0x3b, 0xb77c, 0xbe44, 0x20, 0xc54c, 0x20, 0xc384, 0xb2c8, 0x3b, 0xc8fc,
0xb9c8, 0xb2e4, 0x20, 0xc54c, 0x20, 0xc544, 0xc648, 0x3b, 0xc8fc, 0xb9c8, 0xb2e4, 0x20, 0xc54c, 0x20, 0xc384, 0xb2c8, 0x3b, 0xb77c, 0xc7a1, 0x3b,
0xc250, 0xc544, 0xbc18, 0x3b, 0xb77c, 0xb9c8, 0xb2e8, 0x3b, 0xc250, 0xc648, 0x3b, 0xb4c0, 0x20, 0xc54c, 0x20, 0xae4c, 0xb2e4, 0x3b, 0xb4c0, 0x20,
0xc54c, 0x20, 0xd788, 0xc790, 0x3b, 0x6d, 0x75, 0x1e96, 0x65, 0x72, 0x65, 0x6d, 0x3b, 0x73, 0x65, 0x66, 0x65, 0x72, 0x3b, 0x72,
0x65, 0x62, 0xee, 0x2bf, 0x75, 0x6c, 0x65, 0x77, 0x65, 0x6c, 0x3b, 0x72, 0x65, 0x62, 0xee, 0x2bf, 0x75, 0x6c, 0x61, 0x78,
0x65, 0x72, 0x3b, 0x63, 0x65, 0x6d, 0x61, 0x7a, 0xee, 0x79, 0x65, 0x6c, 0x65, 0x77, 0x65, 0x6c, 0x3b, 0x63, 0x65, 0x6d,
0x61, 0x7a, 0xee, 0x79, 0x65, 0x6c, 0x61, 0x78, 0x65, 0x72, 0x3b, 0x72, 0x65, 0x63, 0x65, 0x62, 0x3b, 0x15f, 0x65, 0x2bf,
0x62, 0x61, 0x6e, 0x3b, 0x72, 0x65, 0x6d, 0x65, 0x7a, 0x61, 0x6e, 0x3b, 0x15f, 0x65, 0x77, 0x61, 0x6c, 0x3b, 0x7a, 0xee,
0x6c, 0x71, 0x65, 0x2bf, 0x64, 0x65, 0x3b, 0x7a, 0xee, 0x6c, 0x1e96, 0x65, 0x63, 0x65, 0x3b, 0xea1, 0xeb8, 0xeae, 0xeb1, 0xe94,
0x3b, 0xec0, 0xe84, 0xeb2, 0xeb0, 0x3b, 0xeae, 0xead, 0xe81, 0xe9a, 0xeb5, 0x20, 0x31, 0x3b, 0xeae, 0xead, 0xe81, 0xe9a, 0xeb5, 0x20,
0x32, 0x3b, 0xe99, 0xeb8, 0xea1, 0xeb2, 0x20, 0x31, 0x3b, 0xe99, 0xeb8, 0xea1, 0xeb2, 0x20, 0x32, 0x3b, 0xec0, 0xeae, 0xeb2, 0xeb0,
0x3b, 0xe8a, 0xeb2, 0x3b, 0xec0, 0xeae, 0xeb2, 0xeb0, 0xea1, 0xeb0, 0x3b, 0xec0, 0xe8a, 0xebb, 0xeb2, 0x3b, 0xe8a, 0xeb8, 0xea5, 0xe81,
0xeb4, 0xead, 0xeb8, 0x3b, 0xe8a, 0xeb8, 0xea5, 0xeab, 0xeb4, 0xe88, 0x3b, 0xea1, 0xeb8, 0xea3, 0xeb0, 0xeae, 0xead, 0xea1, 0x3b, 0xe8a,
0xeb2, 0xe9f, 0xeb2, 0xea3, 0x3b, 0xeae, 0xead, 0xe94, 0xe9a, 0xeb5, 0x20, 0x31, 0x3b, 0xeae, 0xead, 0xe94, 0xe9a, 0xeb5, 0x20, 0x32,
0x3b, 0xe88, 0xeb8, 0xea1, 0xeb2, 0xe94, 0xeb2, 0x20, 0x31, 0x3b, 0xe88, 0xeb8, 0xea1, 0xeb2, 0xe94, 0xeb2, 0x20, 0x32, 0x3b, 0xeae,
0xeb2, 0xe88, 0xeb1, 0xe9a, 0x3b, 0xe8a, 0xeb0, 0xe9a, 0xeb2, 0xe99, 0x3b, 0xeae, 0xeb2, 0xea1, 0xeb2, 0xe94, 0xead, 0xe99, 0x3b, 0xec0,
0xe8a, 0xebb, 0xeb2, 0xea7, 0xeb1, 0xe94, 0x3b, 0xe94, 0xeb8, 0xead, 0xeb1, 0xe94, 0xe81, 0xeb4, 0xe94, 0xeb0, 0x3b, 0xe94, 0xeb8, 0xead,
0xeb1, 0xe94, 0xe81, 0xeb4, 0xe88, 0xeb0, 0x3b, 0xea1, 0xeb8, 0xeae, 0xeb1, 0xe94, 0x3b, 0xec0, 0xe84, 0xeb2, 0xeb0, 0x3b, 0xeae, 0xead,
0xe94, 0xe9a, 0xeb5, 0x20, 0x31, 0x3b, 0xeae, 0xead, 0xe81, 0xe9a, 0xeb5, 0x20, 0x32, 0x3b, 0xe99, 0xeb8, 0xea1, 0xeb2, 0x20, 0x31,
0x3b, 0xe99, 0xeb8, 0xea1, 0xeb2, 0x20, 0x32, 0x3b, 0xec0, 0xeae, 0xeb2, 0xeb0, 0x3b, 0xe8a, 0xeb0, 0xead, 0xecc, 0x3b, 0xec0, 0xeae,
0xeb2, 0xeb0, 0xea1, 0xeb0, 0x3b, 0xec0, 0xe8a, 0xebb, 0xeb2, 0x3b, 0xe8a, 0xeb8, 0xea5, 0xe81, 0xeb4, 0xead, 0xeb8, 0x3b, 0xe8a, 0xeb8,
0xea5, 0xeab, 0xeb4, 0xe88, 0x3b, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x73,
0x3b, 0x31, 0x2e, 0x20, 0x72, 0x61, 0x62, 0x12b, 0x3b, 0x32, 0x2e, 0x20, 0x72, 0x61, 0x62, 0x12b, 0x3b, 0x31, 0x2e, 0x20,
0x64, 0x17e, 0x75, 0x6d, 0x101, 0x64, 0x101, 0x3b, 0x32, 0x2e, 0x20, 0x64, 0x17e, 0x75, 0x6d, 0x101, 0x64, 0x101, 0x3b, 0x72,
0x61, 0x64, 0x17e, 0x61, 0x62, 0x73, 0x3b, 0x161, 0x61, 0x62, 0x61, 0x6e, 0x73, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x101,
0x6e, 0x73, 0x3b, 0x161, 0x61, 0x75, 0x76, 0x61, 0x6c, 0x73, 0x3b, 0x64, 0x75, 0x20, 0x61, 0x6c, 0x2d, 0x6b, 0x69, 0x64,
0x101, 0x3b, 0x64, 0x75, 0x20, 0x61, 0x6c, 0x2d, 0x68, 0x69, 0x64, 0x17e, 0x101, 0x3b, 0x43c, 0x443, 0x445, 0x2e, 0x3b, 0x441,
0x430, 0x444, 0x2e, 0x3b, 0x440, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x3b, 0x440, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x45f,
0x443, 0x43c, 0x2e, 0x20, 0x49, 0x3b, 0x45f, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x440, 0x430, 0x45f, 0x2e, 0x3b, 0x448,
0x430, 0x431, 0x2e, 0x3b, 0x440, 0x430, 0x43c, 0x2e, 0x3b, 0x448, 0x430, 0x432, 0x2e, 0x3b, 0x434, 0x443, 0x43b, 0x43a, 0x2e, 0x3b,
0x434, 0x443, 0x43b, 0x445, 0x2e, 0x3b, 0x43c, 0x443, 0x445, 0x430, 0x440, 0x435, 0x43c, 0x3b, 0x441, 0x430, 0x444, 0x430, 0x440, 0x3b,
0x440, 0x430, 0x431, 0x438, 0x20, 0x49, 0x3b, 0x440, 0x430, 0x431, 0x438, 0x20, 0x49, 0x49, 0x3b, 0x45f, 0x443, 0x43c, 0x430, 0x434,
0x430, 0x20, 0x49, 0x3b, 0x45f, 0x443, 0x43c, 0x430, 0x434, 0x430, 0x20, 0x49, 0x49, 0x3b, 0x440, 0x430, 0x45f, 0x430, 0x431, 0x3b,
0x448, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x440, 0x430, 0x43c, 0x430, 0x434, 0x430, 0x43d, 0x3b, 0x448, 0x430, 0x432, 0x430, 0x43b, 0x3b,
0x434, 0x443, 0x43b, 0x43a, 0x438, 0x434, 0x430, 0x3b, 0x434, 0x443, 0x43b, 0x445, 0x438, 0x45f, 0x430, 0x3b, 0xd2e, 0xd41, 0xd39, 0x2e,
0x3b, 0xd38, 0xd2b, 0x2e, 0x3b, 0xd31, 0xd2c, 0xd40, 0xd39, 0xd41, 0xd7d, 0x20, 0xd05, 0xd35, 0xd4d, 0xd35, 0x2e, 0x3b, 0xd31, 0xd2c,
0xd40, 0xd39, 0xd41, 0xd7d, 0x20, 0xd06, 0xd16, 0xd3f, 0x2e, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26, 0xd41, 0xd7d, 0x20, 0xd05, 0xd35, 0xd4d,
0xd35, 0x2e, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26, 0xd41, 0xd7d, 0x20, 0xd06, 0xd16, 0xd3f, 0x2e, 0x3b, 0xd31, 0xd1c, 0x2e, 0x3b, 0xd36,
0xd39, 0xd2c, 0xd3e, 0x2e, 0x3b, 0xd31, 0xd2e, 0xd26, 0xd3e, 0x2e, 0x3b, 0xd36, 0xd35, 0xd4d, 0xd35, 0xd3e, 0x2e, 0x3b, 0xd26, 0xd41,
0xd7d, 0x20, 0xd16, 0xd39, 0x2e, 0x3b, 0xd26, 0xd41, 0xd7d, 0x20, 0xd39, 0xd3f, 0x2e, 0x3b, 0xd2e, 0xd41, 0xd39, 0xd31, 0xd02, 0x3b,
0xd38, 0xd2b, 0xd7c, 0x3b, 0xd31, 0xd2c, 0xd40, 0xd39, 0xd41, 0xd7d, 0x20, 0xd05, 0xd35, 0xd4d, 0xd35, 0xd7d, 0x3b, 0xd31, 0xd2c, 0xd40,
0xd39, 0xd41, 0xd7d, 0x20, 0xd06, 0xd16, 0xd3f, 0xd7c, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26, 0xd41, 0xd7d, 0x20, 0xd05, 0xd35, 0xd4d, 0xd35,
0xd7d, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26, 0xd41, 0xd7d, 0x20, 0xd06, 0xd16, 0xd3f, 0xd7c, 0x3b, 0xd31, 0xd1c, 0xd2c, 0xd4d, 0x3b, 0xd36,
0xd39, 0xd2c, 0xd3e, 0xd7b, 0x3b, 0xd31, 0xd2e, 0xd26, 0xd3e, 0xd7b, 0x3b, 0xd36, 0xd35, 0xd4d, 0xd35, 0xd3e, 0xd7d, 0x3b, 0xd26, 0xd41,
0xd7d, 0x20, 0xd16, 0xd39, 0xd26, 0xd4d, 0x3b, 0xd26, 0xd41, 0xd7d, 0x20, 0xd39, 0xd3f, 0xd1c, 0xd4d, 0xd1c, 0x3b, 0xd2e, 0xd41, 0x3b,
0xd38, 0x3b, 0xd31, 0x3b, 0xd31, 0x3b, 0xd1c, 0x3b, 0xd1c, 0x3b, 0xd31, 0x3b, 0xd36, 0x3b, 0xd31, 0x3b, 0xd36, 0x3b, 0xd26, 0xd41,
0x3b, 0xd26, 0xd41, 0x3b, 0xd2e, 0xd41, 0xd39, 0xd31, 0xd02, 0x3b, 0xd38, 0xd2b, 0xd7c, 0x3b, 0xd31, 0xd2c, 0xd40, 0xd39, 0xd41, 0xd7d,
0x20, 0xd05, 0xd35, 0xd4d, 0xd35, 0xd7d, 0x3b, 0xd31, 0xd2c, 0xd40, 0xd39, 0xd41, 0xd7d, 0x20, 0xd06, 0xd16, 0xd3f, 0xd7c, 0x3b, 0xd1c,
0xd2e, 0xd3e, 0xd26, 0xd41, 0xd7d, 0x20, 0xd05, 0xd35, 0xd4d, 0xd35, 0xd7d, 0x3b, 0xd1c, 0xd2e, 0xd3e, 0xd26, 0xd41, 0xd7d, 0x20, 0xd06,
0xd16, 0xd3f, 0xd7c, 0x3b, 0xd31, 0xd1c, 0xd2c, 0xd4d, 0x3b, 0xd36, 0xd39, 0xd2c, 0xd3e, 0xd7b, 0x3b, 0xd31, 0xd2e, 0xd33, 0xd3e, 0xd7b,
0x3b, 0xd36, 0xd35, 0xd4d, 0xd35, 0xd3e, 0xd7d, 0x3b, 0xd26, 0xd41, 0xd7d, 0x20, 0xd16, 0xd39, 0xd26, 0xd4d, 0x3b, 0xd26, 0xd41, 0xd7d,
0x20, 0xd39, 0xd3f, 0xd1c, 0xd4d, 0xd1c, 0x3b, 0x92e, 0x94b, 0x939, 0x2e, 0x3b, 0x938, 0x92b, 0x2e, 0x3b, 0x930, 0x93e, 0x92c, 0x940,
0x20, 0x49, 0x3b, 0x930, 0x93e, 0x92c, 0x940, 0x20, 0x49, 0x49, 0x3b, 0x91c, 0x941, 0x92e, 0x93e, 0x2e, 0x20, 0x49, 0x3b, 0x91c,
0x941, 0x92e, 0x93e, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x930, 0x91d, 0x93e, 0x2e, 0x3b, 0x936, 0x93e, 0x92c, 0x93e, 0x2e, 0x3b, 0x930,
0x92e, 0x2e, 0x3b, 0x936, 0x935, 0x94d, 0x935, 0x93e, 0x2e, 0x3b, 0x927, 0x941, 0x932, 0x2d, 0x915, 0x940, 0x2e, 0x3b, 0x927, 0x941,
0x932, 0x2d, 0x939, 0x93f, 0x2e, 0x3b, 0x92e, 0x94b, 0x939, 0x930, 0x92e, 0x3b, 0x938, 0x92b, 0x930, 0x3b, 0x930, 0x93e, 0x92c, 0x940,
0x20, 0x49, 0x3b, 0x930, 0x93e, 0x92c, 0x940, 0x20, 0x49, 0x49, 0x3b, 0x91c, 0x941, 0x92e, 0x93e, 0x926, 0x93e, 0x20, 0x49, 0x3b,
0x91c, 0x941, 0x92e, 0x93e, 0x926, 0x93e, 0x20, 0x49, 0x49, 0x3b, 0x930, 0x91d, 0x93e, 0x92c, 0x3b, 0x936, 0x93e, 0x92c, 0x93e, 0x928,
0x3b, 0x930, 0x92e, 0x91c, 0x93e, 0x928, 0x3b, 0x936, 0x935, 0x94d, 0x935, 0x93e, 0x932, 0x3b, 0x927, 0x941, 0x932, 0x2d, 0x915, 0x940,
0x926, 0x93e, 0x939, 0x3b, 0x927, 0x941, 0x932, 0x2d, 0x939, 0x93f, 0x91c, 0x93e, 0x939, 0x3b, 0x967, 0x3b, 0x968, 0x3b, 0x969, 0x3b,
0x96a, 0x3b, 0x96b, 0x3b, 0x96c, 0x3b, 0x96d, 0x3b, 0x96e, 0x3b, 0x96f, 0x3b, 0x967, 0x966, 0x3b, 0x967, 0x967, 0x3b, 0x967, 0x968,
0x3b, 0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x72, 0x61,
0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49,
0x3b, 0x72, 0x61, 0x6a, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x77,
0x2e, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x71, 0x2e, 0x3b, 0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x2e, 0x3b,
0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb,
0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49,
0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x72, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x73, 0x68, 0x61,
0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x73, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c,
0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x71, 0x69, 0x2bb, 0x64, 0x61, 0x68, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d,
0x68, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x3b, 0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62,
0x2e, 0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x6a,
0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x72, 0x61, 0x6a, 0x2e, 0x3b, 0x73, 0x68, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d,
0x2e, 0x3b, 0x73, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x71, 0x2e, 0x3b, 0x64, 0x68, 0x75,
0x2bb, 0x6c, 0x2d, 0x68, 0x2e, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x3b,
0x631, 0x628, 0x64a, 0x639, 0x20, 0x49, 0x49, 0x3b, 0x62c, 0x645, 0x627, 0x639, 0x647, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x64a, 0x20,
0x6f2, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648,
0x627, 0x644, 0x3b, 0x62f, 0x627, 0x644, 0x642, 0x627, 0x639, 0x62f, 0x647, 0x3b, 0x630, 0x64a, 0x20, 0x627, 0x644, 0x62d, 0x62c, 0x3b,
0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x20, 0x49,
0x49, 0x3b, 0x62c, 0x645, 0x627, 0x639, 0x647, 0x3b, 0x62c, 0x645, 0x648, 0x645, 0x627, 0x20, 0x49, 0x49, 0x3b, 0x631, 0x62c, 0x628,
0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x62f, 0x627,
0x644, 0x642, 0x627, 0x639, 0x62f, 0x647, 0x3b, 0x630, 0x64a, 0x20, 0x627, 0x644, 0x62d, 0x62c, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b,
0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x20, 0x49, 0x49, 0x3b, 0x62c, 0x645, 0x627,
0x62f, 0x20, 0x6f1, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x20, 0x6f2, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646,
0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x62f, 0x627, 0x644, 0x642, 0x627, 0x639, 0x62f, 0x647,
0x3b, 0x630, 0x64a, 0x20, 0x627, 0x644, 0x62d, 0x62c, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628,
0x64a, 0x639, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x20, 0x49, 0x49, 0x3b, 0x62c, 0x645, 0x627, 0x639, 0x647, 0x3b, 0x62c, 0x645, 0x648,
0x645, 0x627, 0x20, 0x49, 0x49, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627,
0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x64a, 0x20, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x647, 0x3b, 0x630, 0x64a, 0x20,
0x627, 0x644, 0x62d, 0x62c, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x62f, 0x20, 0x635, 0x641, 0x631, 0x6d2, 0x20, 0x62f, 0x3b, 0x631,
0x628, 0x64a, 0x639, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x20, 0x49, 0x49, 0x3b, 0x62c, 0x645, 0x627, 0x639, 0x647, 0x3b, 0x62c, 0x645,
0x648, 0x645, 0x627, 0x20, 0x49, 0x49, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636,
0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x62f, 0x627, 0x644, 0x642, 0x627, 0x639, 0x62f, 0x647, 0x3b, 0x630, 0x64a, 0x20,
0x627, 0x644, 0x62d, 0x62c, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x62f, 0x20, 0x635, 0x641, 0x631, 0x6d2, 0x20, 0x62f, 0x3b, 0x631,
0x628, 0x64a, 0x639, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x20, 0x49, 0x49, 0x3b, 0x62c, 0x645, 0x627, 0x639, 0x647, 0x3b, 0x62c, 0x645,
0x648, 0x645, 0x627, 0x20, 0x49, 0x49, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636,
0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x64a, 0x20, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x647, 0x3b, 0x630, 0x64a,
0x20, 0x627, 0x644, 0x62d, 0x62c, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x200c,
0x627, 0x644, 0x627, 0x648, 0x644, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x200c, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x6cc, 0x3b, 0x62c, 0x645,
0x627, 0x62f, 0x6cc, 0x200c, 0x627, 0x644, 0x627, 0x648, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x200c, 0x627, 0x644, 0x62b, 0x627,
0x646, 0x6cc, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634,
0x648, 0x627, 0x644, 0x3b, 0x630, 0x6cc, 0x642, 0x639, 0x62f, 0x647, 0x3b, 0x630, 0x6cc, 0x62d, 0x62c, 0x647, 0x3b, 0x645, 0x3b, 0x635,
0x3b, 0x631, 0x3b, 0x631, 0x3b, 0x62c, 0x3b, 0x62c, 0x3b, 0x631, 0x3b, 0x634, 0x3b, 0x631, 0x3b, 0x634, 0x3b, 0x630, 0x3b, 0x630,
0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x200c, 0x627, 0x644, 0x627, 0x648, 0x644,
0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x200c, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x6cc, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x200c, 0x627,
0x644, 0x627, 0x648, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x200c, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x6cc, 0x3b, 0x631, 0x62c,
0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630,
0x6cc, 0x642, 0x639, 0x62f, 0x647, 0x654, 0x3b, 0x630, 0x6cc, 0x62d, 0x62c, 0x647, 0x654, 0x3b, 0x4d, 0x75, 0x68, 0x2e, 0x3b, 0x53,
0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x44,
0x17c, 0x75, 0x2e, 0x20, 0x49, 0x3b, 0x44, 0x17c, 0x75, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x2e, 0x3b, 0x53, 0x7a,
0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x7a, 0x61, 0x77, 0x2e, 0x3b, 0x5a, 0x75, 0x20, 0x61, 0x6c, 0x2d,
0x6b, 0x2e, 0x3b, 0x5a, 0x75, 0x20, 0x61, 0x6c, 0x2d, 0x68, 0x2e, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d,
0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb,
0x20, 0x49, 0x49, 0x3b, 0x44, 0x17c, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x44, 0x17c, 0x75, 0x6d, 0x61, 0x64,
0x61, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x64, 0x17c, 0x61, 0x62, 0x3b, 0x53, 0x7a, 0x61, 0x62, 0x61, 0x6e, 0x3b, 0x52,
0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x7a, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x5a, 0x75, 0x20, 0x61, 0x6c,
0x2d, 0x6b, 0x61, 0x64, 0x61, 0x3b, 0x5a, 0x75, 0x20, 0x61, 0x6c, 0x2d, 0x68, 0x69, 0x64, 0x17c, 0x64, 0x17c, 0x61, 0x3b,
0xa2e, 0xa41, 0xa39, 0xa71, 0x2e, 0x3b, 0xa38, 0xa2b, 0x2e, 0x3b, 0xa30, 0xa2c, 0x2e, 0x20, 0x49, 0x3b, 0xa30, 0xa2c, 0x2e, 0x20,
0x49, 0x49, 0x3b, 0xa1c, 0xa41, 0xa2e, 0x2e, 0x20, 0x49, 0x3b, 0xa1c, 0xa41, 0xa2e, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0xa30, 0xa3e,
0xa1c, 0x2e, 0x3b, 0xa38, 0xa3c, 0xa3e, 0x2e, 0x3b, 0xa30, 0xa3e, 0xa2e, 0x2e, 0x3b, 0xa38, 0xa3c, 0xa05, 0x2e, 0x3b, 0xa26, 0xa42,
0x2d, 0xa05, 0xa32, 0x2d, 0xa15, 0xa40, 0x2e, 0x3b, 0xa26, 0xa42, 0x2d, 0xa05, 0xa32, 0x2d, 0xa39, 0xa3f, 0x2e, 0x3b, 0xa2e, 0xa41,
0xa39, 0xa71, 0xa30, 0xa2e, 0x3b, 0xa38, 0xa2b, 0xa30, 0x3b, 0xa30, 0xa2c, 0xa40, 0x2bb, 0x20, 0x49, 0x3b, 0xa30, 0xa2c, 0xa40, 0x2bb,
0x20, 0x49, 0x49, 0x3b, 0xa1c, 0xa41, 0xa2e, 0xa3e, 0xa26, 0xa3e, 0x20, 0x49, 0x3b, 0xa1c, 0xa41, 0xa2e, 0xa3e, 0xa26, 0xa3e, 0x20,
0x49, 0x49, 0x3b, 0xa30, 0xa1c, 0xa2c, 0x3b, 0xa38, 0xa3c, 0xa2c, 0xa3e, 0xa28, 0x3b, 0xa30, 0xa2e, 0xa1c, 0xa3c, 0xa3e, 0xa28, 0x3b,
0xa38, 0xa3c, 0xa35, 0xa3e, 0xa32, 0x3b, 0xa26, 0xa42, 0x2d, 0xa05, 0xa32, 0x2d, 0xa15, 0xa40, 0xa26, 0xa3e, 0xa39, 0x3b, 0xa26, 0xa42,
0x2d, 0xa05, 0xa32, 0x2d, 0xa39, 0xa3f, 0xa1c, 0xa4d, 0xa39, 0xa3e, 0x3b, 0xa2e, 0xa41, 0xa39, 0xa71, 0xa30, 0xa2e, 0x3b, 0xa38, 0xa2b,
0xa30, 0x3b, 0xa30, 0xa2c, 0xa40, 0x20, 0x2bb, 0x20, 0x49, 0x3b, 0xa30, 0xa2c, 0xa40, 0x20, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0xa1c,
0xa41, 0xa2e, 0xa3e, 0xa26, 0xa3e, 0x20, 0x49, 0x3b, 0xa1c, 0xa41, 0xa2e, 0xa3e, 0xa26, 0xa3e, 0x20, 0x49, 0x49, 0x3b, 0xa30, 0xa1c,
0xa2c, 0x3b, 0xa38, 0xa3c, 0xa2c, 0xa3e, 0xa28, 0x3b, 0xa30, 0xa2e, 0xa1c, 0xa3c, 0xa3e, 0xa28, 0x3b, 0xa38, 0xa3c, 0xa35, 0xa3e, 0xa32,
0x3b, 0xa26, 0xa42, 0x2d, 0xa05, 0xa32, 0x2d, 0xa15, 0xa40, 0xa26, 0xa3e, 0xa39, 0x3b, 0xa26, 0xa42, 0x2d, 0xa05, 0xa32, 0x2d, 0xa39,
0xa3f, 0xa1c, 0xa4d, 0xa39, 0xa3e, 0x3b, 0x43c, 0x443, 0x445, 0x2e, 0x3b, 0x441, 0x430, 0x444, 0x2e, 0x3b, 0x440, 0x430, 0x431, 0x2e,
0x20, 0x49, 0x3b, 0x440, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x3b, 0x434,
0x436, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x440, 0x430, 0x434, 0x436, 0x2e, 0x3b, 0x448, 0x430, 0x430, 0x431, 0x2e, 0x3b,
0x440, 0x430, 0x43c, 0x2e, 0x3b, 0x448, 0x430, 0x432, 0x2e, 0x3b, 0x437, 0x443, 0x43b, 0x44c, 0x2d, 0x43a, 0x2e, 0x3b, 0x437, 0x443,
0x43b, 0x44c, 0x2d, 0x445, 0x2e, 0x3b, 0x43c, 0x443, 0x445, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b, 0x441, 0x430, 0x444, 0x430, 0x440,
0x3b, 0x440, 0x430, 0x431, 0x438, 0x2d, 0x443, 0x43b, 0x44c, 0x2d, 0x430, 0x432, 0x432, 0x430, 0x43b, 0x44c, 0x3b, 0x440, 0x430, 0x431,
0x438, 0x2d, 0x443, 0x43b, 0x44c, 0x2d, 0x430, 0x445, 0x438, 0x440, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430, 0x434, 0x2d, 0x443, 0x43b,
0x44c, 0x2d, 0x430, 0x432, 0x432, 0x430, 0x43b, 0x44c, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430, 0x434, 0x2d, 0x443, 0x43b, 0x44c, 0x2d,
0x430, 0x445, 0x438, 0x440, 0x3b, 0x440, 0x430, 0x434, 0x436, 0x430, 0x431, 0x3b, 0x448, 0x430, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x440,
0x430, 0x43c, 0x430, 0x434, 0x430, 0x43d, 0x3b, 0x448, 0x430, 0x432, 0x432, 0x430, 0x43b, 0x44c, 0x3b, 0x437, 0x443, 0x43b, 0x44c, 0x2d,
0x43a, 0x430, 0x430, 0x434, 0x430, 0x3b, 0x437, 0x443, 0x43b, 0x44c, 0x2d, 0x445, 0x438, 0x434, 0x436, 0x436, 0x430, 0x3b, 0x41c, 0x443,
0x445, 0x2e, 0x3b, 0x421, 0x430, 0x444, 0x2e, 0x3b, 0x420, 0x435, 0x431, 0x2e, 0x20, 0x31, 0x3b, 0x420, 0x435, 0x431, 0x2e, 0x20,
0x32, 0x3b, 0x40f, 0x443, 0x43c, 0x2e, 0x20, 0x31, 0x3b, 0x40f, 0x443, 0x43c, 0x2e, 0x20, 0x32, 0x3b, 0x420, 0x435, 0x45f, 0x2e,
0x3b, 0x428, 0x430, 0x2e, 0x3b, 0x420, 0x430, 0x43c, 0x2e, 0x3b, 0x428, 0x435, 0x2e, 0x3b, 0x417, 0x443, 0x43b, 0x2d, 0x43a, 0x2e,
0x3b, 0x417, 0x443, 0x43b, 0x2d, 0x445, 0x2e, 0x3b, 0x41c, 0x443, 0x445, 0x430, 0x440, 0x435, 0x43c, 0x3b, 0x421, 0x430, 0x444, 0x435,
0x440, 0x3b, 0x420, 0x435, 0x431, 0x438, 0x20, 0x31, 0x3b, 0x420, 0x435, 0x431, 0x438, 0x20, 0x32, 0x3b, 0x40f, 0x443, 0x43c, 0x430,
0x434, 0x435, 0x20, 0x31, 0x3b, 0x40f, 0x443, 0x43c, 0x430, 0x434, 0x435, 0x20, 0x32, 0x3b, 0x420, 0x435, 0x45f, 0x435, 0x431, 0x3b,
0x428, 0x430, 0x2bb, 0x431, 0x430, 0x43d, 0x3b, 0x420, 0x430, 0x43c, 0x430, 0x437, 0x430, 0x43d, 0x3b, 0x428, 0x435, 0x432, 0x430, 0x43b,
0x3b, 0x417, 0x443, 0x43b, 0x2d, 0x43a, 0x430, 0x434, 0x435, 0x3b, 0x417, 0x443, 0x43b, 0x2d, 0x445, 0x438, 0x45f, 0x435, 0x3b, 0x41c,
0x443, 0x440, 0x430, 0x445, 0x430, 0x43c, 0x3b, 0x421, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x2bb, 0x20, 0x49,
0x3b, 0x420, 0x430, 0x431, 0x438, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x408, 0x443, 0x43c, 0x430, 0x434, 0x430, 0x20, 0x49, 0x3b, 0x408,
0x443, 0x43c, 0x430, 0x434, 0x430, 0x20, 0x49, 0x49, 0x3b, 0x420, 0x430, 0x452, 0x430, 0x431, 0x3b, 0x428, 0x430, 0x2bb, 0x431, 0x430,
0x43d, 0x3b, 0x420, 0x430, 0x43c, 0x430, 0x434, 0x430, 0x43d, 0x3b, 0x428, 0x430, 0x432, 0x430, 0x43b, 0x3b, 0x414, 0x443, 0x2bb, 0x43b,
0x2d, 0x41a, 0x438, 0x2bb, 0x434, 0x430, 0x3b, 0x414, 0x443, 0x2bb, 0x43b, 0x2d, 0x445, 0x438, 0x452, 0x430, 0x3b, 0x4d, 0x75, 0x68,
0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x65, 0x62, 0x2e, 0x20, 0x31, 0x3b, 0x52, 0x65, 0x62, 0x2e, 0x20, 0x32,
0x3b, 0x44, 0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x31, 0x3b, 0x44, 0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x32, 0x3b, 0x52, 0x65, 0x64,
0x17e, 0x2e, 0x3b, 0x160, 0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x160, 0x65, 0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x2d,
0x6b, 0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x2d, 0x68, 0x2e, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x65, 0x6d, 0x3b, 0x53, 0x61,
0x66, 0x65, 0x72, 0x3b, 0x52, 0x65, 0x62, 0x69, 0x20, 0x31, 0x3b, 0x52, 0x65, 0x62, 0x69, 0x20, 0x32, 0x3b, 0x44, 0x17e,
0x75, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x31, 0x3b, 0x44, 0x17e, 0x75, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x32, 0x3b, 0x52, 0x65,
0x64, 0x17e, 0x65, 0x62, 0x3b, 0x160, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x7a, 0x61, 0x6e, 0x3b,
0x160, 0x65, 0x76, 0x61, 0x6c, 0x3b, 0x5a, 0x75, 0x6c, 0x2d, 0x6b, 0x61, 0x64, 0x65, 0x3b, 0x5a, 0x75, 0x6c, 0x2d, 0x68,
0x69, 0x64, 0x17e, 0x65, 0x3b, 0x4d, 0x75, 0x72, 0x61, 0x68, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52,
0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x61,
0x64, 0x61, 0x20, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x111, 0x61, 0x62,
0x3b, 0x160, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x160, 0x61, 0x76, 0x61,
0x6c, 0x3b, 0x44, 0x75, 0x2bb, 0x6c, 0x2d, 0x4b, 0x69, 0x2bb, 0x64, 0x61, 0x3b, 0x44, 0x75, 0x2bb, 0x6c, 0x2d, 0x68, 0x69,
0x111, 0x61, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x64a, 0x639, 0x20, 0x627, 0x644, 0x627,
0x648, 0x644, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x627, 0x62e, 0x631, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20,
0x627, 0x644, 0x627, 0x648, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x64a, 0x20, 0x627, 0x644, 0x627, 0x62e, 0x631, 0x3b, 0x631, 0x62c,
0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630,
0x648, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x3b, 0x630, 0x648, 0x627, 0x644, 0x62d, 0x62c, 0x6c1, 0x3b, 0x6d, 0x75, 0x68, 0x2e, 0x3b,
0x73, 0x61, 0x66, 0x2e, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b,
0x64, 0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x72, 0x61, 0x64,
0x2e, 0x3b, 0x161, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b, 0x161, 0x61, 0x75, 0x2e, 0x3b, 0x64, 0x68, 0xfa, 0x20,
0x6c, 0x2d, 0x6b, 0x2e, 0x3b, 0x64, 0x68, 0xfa, 0x20, 0x6c, 0x2d, 0x68, 0x2e, 0x3b, 0x61, 0x6c, 0x2d, 0x6d, 0x75, 0x68,
0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62, 0xed, 0xb4, 0x20, 0x61, 0x6c,
0x2d, 0x61, 0x76, 0x76, 0x61, 0x6c, 0x3b, 0x72, 0x61, 0x62, 0xed, 0xb4, 0x61, 0x74, 0x68, 0x2d, 0x74, 0x68, 0xe1, 0x6e,
0xed, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0xe1, 0x64, 0xe1, 0x20, 0x6c, 0x2d, 0xfa, 0x6c, 0xe1, 0x3b, 0x64, 0x17e, 0x75, 0x6d,
0xe1, 0x64, 0xe1, 0x20, 0x6c, 0x2d, 0xe1, 0x63, 0x68, 0x69, 0x72, 0x61, 0x3b, 0x72, 0x61, 0x64, 0x17e, 0x61, 0x62, 0x3b,
0x161, 0x61, 0xb4, 0x20, 0x62, 0xe1, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0xe1, 0x6e, 0x3b, 0x161, 0x61, 0x75, 0x76,
0xe1, 0x6c, 0x3b, 0x64, 0x68, 0xfa, 0x20, 0x6c, 0x2d, 0x6b, 0x61, 0xb4, 0x20, 0x64, 0x61, 0x3b, 0x64, 0x68, 0xfa, 0x20,
0x6c, 0x2d, 0x68, 0x69, 0x64, 0x17e, 0x64, 0x17e, 0x61, 0x3b, 0x4d, 0x75, 0x78, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b,
0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20,
0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x6a, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x2e, 0x3b,
0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x44, 0x75, 0x6c, 0x2d, 0x51, 0x2e, 0x3b, 0x44, 0x75,
0x6c, 0x2d, 0x58, 0x2e, 0x3b, 0x4d, 0x75, 0x78, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b,
0x52, 0x61, 0x62, 0x69, 0x63, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x63,
0x20, 0x61, 0x6c, 0x2d, 0x74, 0x68, 0x61, 0x6e, 0x69, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x61, 0x6c, 0x2d,
0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x61, 0x6c, 0x2d, 0x74, 0x68, 0x61, 0x6e,
0x69, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x68, 0x61, 0x63, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61,
0x64, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x44, 0x75, 0x6c, 0x20, 0x61, 0x6c, 0x2d, 0x71,
0x61, 0x63, 0x64, 0x61, 0x68, 0x3b, 0x44, 0x75, 0x6c, 0x20, 0x78, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x3b, 0x4d, 0x75, 0x78,
0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49,
0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x52, 0x61, 0x6a,
0x2e, 0x3b, 0x53, 0x68, 0x61, 0x2e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x2e, 0x3b, 0x44, 0x68,
0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x2e, 0x3b, 0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x2e, 0x3b, 0x4d, 0x75, 0x78, 0x61,
0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x63, 0x20, 0x61, 0x6c, 0x2d,
0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x63, 0x20, 0x61, 0x6c, 0x2d, 0x74, 0x68, 0x61, 0x6e, 0x69,
0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x6a, 0x75, 0x6d,
0x61, 0x64, 0x61, 0x20, 0x61, 0x6c, 0x2d, 0x74, 0x68, 0x61, 0x6e, 0x69, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53,
0x68, 0x61, 0x63, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x77,
0x61, 0x6c, 0x3b, 0x44, 0x75, 0x6c, 0x20, 0x61, 0x6c, 0x2d, 0x71, 0x61, 0x63, 0x64, 0x61, 0x3b, 0x44, 0x75, 0x6c, 0x20,
0x78, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x3b, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61,
0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x6a,
0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x49, 0x3b, 0x72, 0x61,
0x6a, 0x61, 0x62, 0x3b, 0x73, 0x68, 0x61, 0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0xe1, 0x6e, 0x3b,
0x73, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x71, 0x69, 0x2bb, 0x64, 0x61, 0x68,
0x3b, 0x64, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72,
0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2019, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x77,
0x77, 0x61, 0x6c, 0x3b, 0x52, 0x61, 0x62, 0x69, 0x2019, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x4a,
0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c, 0x2d, 0x75, 0x6c, 0x61, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c,
0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x61, 0x3b, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x53, 0x68, 0x61, 0x2019, 0x62, 0x61,
0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x53, 0x68, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x44, 0x68,
0x75, 0x2d, 0x6c, 0x2d, 0x67, 0x61, 0x2019, 0x64, 0x61, 0x3b, 0x44, 0x68, 0x75, 0x2d, 0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a,
0x61, 0x3b, 0x6d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x72, 0x61, 0x62,
0x69, 0x2019, 0x20, 0x61, 0x6c, 0x2d, 0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2019, 0x20, 0x61, 0x6c,
0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x3b, 0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c, 0x2d, 0x75, 0x6c, 0x61, 0x3b,
0x6a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x2d, 0x6c, 0x2d, 0x61, 0x6b, 0x68, 0x69, 0x72, 0x61, 0x3b, 0x72, 0x61, 0x6a, 0x61,
0x62, 0x3b, 0x73, 0x68, 0x61, 0x2019, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x73, 0x68,
0x61, 0x77, 0x77, 0x61, 0x6c, 0x3b, 0x64, 0x68, 0x75, 0x2d, 0x6c, 0x2d, 0x67, 0x61, 0x2019, 0x64, 0x61, 0x3b, 0x64, 0x68,
0x75, 0x2d, 0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a, 0x61, 0x3b, 0x41c, 0x443, 0x4b3, 0x2e, 0x3b, 0x421, 0x430, 0x444, 0x2e, 0x3b,
0x420, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x3b, 0x420, 0x430, 0x431, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x4b6, 0x443, 0x43c, 0x2e, 0x20,
0x49, 0x3b, 0x4b6, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x420, 0x430, 0x4b7, 0x2e, 0x3b, 0x428, 0x430, 0x2e, 0x3b, 0x420,
0x430, 0x43c, 0x2e, 0x3b, 0x428, 0x430, 0x432, 0x2e, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d, 0x49a, 0x2e, 0x3b, 0x414, 0x445, 0x443,
0x43b, 0x2d, 0x4b2, 0x2e, 0x3b, 0x43c, 0x443, 0x4b3, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b, 0x441, 0x430, 0x444, 0x430, 0x440, 0x3b,
0x420, 0x430, 0x431, 0x435, 0x44a, 0x20, 0x49, 0x3b, 0x420, 0x430, 0x431, 0x435, 0x44a, 0x20, 0x49, 0x49, 0x3b, 0x4b7, 0x438, 0x43c,
0x43e, 0x434, 0x438, 0x2d, 0x443, 0x43b, 0x2d, 0x443, 0x43b, 0x43e, 0x3b, 0x4b7, 0x438, 0x43c, 0x43e, 0x434, 0x438, 0x2d, 0x443, 0x43b,
0x2d, 0x441, 0x43e, 0x43d, 0x438, 0x3b, 0x440, 0x430, 0x4b7, 0x430, 0x431, 0x3b, 0x428, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x420, 0x430,
0x43c, 0x430, 0x434, 0x430, 0x43d, 0x3b, 0x428, 0x430, 0x432, 0x432, 0x430, 0x43b, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d, 0x49a, 0x438,
0x434, 0x430, 0x4b3, 0x3b, 0x414, 0x445, 0x443, 0x43b, 0x2d, 0x4b2, 0x438, 0x4b7, 0x4b7, 0x430, 0x4b3, 0x3b, 0x43c, 0x443, 0x4b3, 0x430,
0x440, 0x440, 0x430, 0x43c, 0x3b, 0x441, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x420, 0x430, 0x431, 0x435, 0x44a, 0x20, 0x49, 0x3b, 0x420,
0x430, 0x431, 0x435, 0x44a, 0x20, 0x49, 0x49, 0x3b, 0x4b7, 0x438, 0x43c, 0x43e, 0x434, 0x438, 0x2d, 0x443, 0x43b, 0x2d, 0x443, 0x43b,
0x43e, 0x3b, 0x4b7, 0x438, 0x43c, 0x43e, 0x434, 0x438, 0x2d, 0x443, 0x43b, 0x2d, 0x441, 0x43e, 0x43d, 0x438, 0x3b, 0x440, 0x430, 0x4b7,
0x430, 0x431, 0x3b, 0x428, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x420, 0x430, 0x43c, 0x430, 0x434, 0x430, 0x43d, 0x3b, 0x428, 0x430, 0x432,
0x432, 0x430, 0x43b, 0x3b, 0x414, 0x445, 0x443, 0x442, 0x2d, 0x49a, 0x438, 0x434, 0x430, 0x4b3, 0x3b, 0x414, 0x445, 0x443, 0x442, 0x2d,
0x4b2, 0x438, 0x4b7, 0x4b7, 0x430, 0x4b3, 0x3b, 0xbae, 0xbc1, 0xbb9, 0x2e, 0x3b, 0xb9a, 0xb83, 0xbaa, 0x2e, 0x3b, 0xbb0, 0xbaa, 0xbbf,
0x20, 0x31, 0x3b, 0xbb0, 0xbaa, 0xbbf, 0x20, 0x32, 0x3b, 0xb9c, 0xbc1, 0xbae, 0x2e, 0x20, 0x31, 0x3b, 0xb9c, 0xbc1, 0xbae, 0x2e,
0x20, 0x32, 0x3b, 0xbb0, 0xb9c, 0x2e, 0x3b, 0xbb7, 0xb83, 0x2e, 0x3b, 0xbb0, 0xbae, 0x2e, 0x3b, 0xbb7, 0xbb5, 0xbcd, 0x2e, 0x3b,
0xba4, 0xbc1, 0xbb2, 0xbcd, 0x20, 0xb95, 0xb83, 0x2e, 0x3b, 0xba4, 0xbc1, 0xbb2, 0xbcd, 0x20, 0xbb9, 0xbbf, 0xb9c, 0xbcd, 0x2e, 0x3b,
0xbae, 0xbc1, 0xbb9, 0xbb0, 0xbcd, 0xbb0, 0xbae, 0xbcd, 0x3b, 0xb9a, 0xb83, 0xbaa, 0xbb0, 0xbcd, 0x3b, 0xbb0, 0xbaa, 0xbbf, 0x20, 0x31,
0x3b, 0xbb0, 0xbaa, 0xbbf, 0x20, 0x32, 0x3b, 0xb9c, 0xbc1, 0xbae, 0xba4, 0xbbe, 0x20, 0x31, 0x3b, 0xb9c, 0xbc1, 0xbae, 0xba4, 0xbbe,
0x20, 0x32, 0x3b, 0xbb0, 0xb9c, 0xbaa, 0xbcd, 0x3b, 0xbb7, 0xb83, 0xbaa, 0xbbe, 0xba9, 0xbcd, 0x3b, 0xbb0, 0xbae, 0xbb2, 0xbbe, 0xba9,
0xbcd, 0x3b, 0xbb7, 0xbb5, 0xbcd, 0xbb5, 0xbbe, 0xbb2, 0xbcd, 0x3b, 0xba4, 0xbc1, 0xbb2, 0xbcd, 0x20, 0xb95, 0xb83, 0xba4, 0xbbe, 0x3b,
0xba4, 0xbc1, 0xbb2, 0xbcd, 0x20, 0xbb9, 0xbbf, 0xb9c, 0xbcd, 0xb9c, 0xbbe, 0x3b, 0xc2e, 0xc41, 0xc39, 0x2e, 0x3b, 0xc38, 0xc2b, 0x2e,
0x3b, 0xc30, 0x2e, 0x20, 0x49, 0x3b, 0xc30, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0xc1c, 0xc41, 0xc2e, 0x2e, 0x20, 0x49, 0x3b, 0xc1c,
0xc41, 0xc2e, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0xc30, 0xc1c, 0x2e, 0x3b, 0xc37, 0xc2c, 0xc3e, 0x2e, 0x3b, 0xc30, 0xc02, 0xc1c, 0xc3e,
0x2e, 0x3b, 0xc37, 0xc35, 0xc4d, 0xc35, 0xc3e, 0x2e, 0x3b, 0xc27, 0xc41, 0xc32, 0xc4d, 0x2d, 0xc15, 0xc3f, 0x2e, 0x3b, 0xc27, 0xc41,
0xc32, 0xc4d, 0x2d, 0xc39, 0xc3f, 0x2e, 0x3b, 0xc2e, 0xc41, 0xc39, 0xc30, 0xc4d, 0xc30, 0xc02, 0x3b, 0xc38, 0xc2b, 0xc30, 0xc4d, 0x3b,
0xc30, 0xc2c, 0xc40, 0x20, 0x49, 0x3b, 0xc30, 0xc2c, 0xc40, 0x20, 0x49, 0x49, 0x3b, 0xc1c, 0xc41, 0xc2e, 0xc26, 0xc3e, 0x20, 0x49,
0x3b, 0xc1c, 0xc41, 0xc2e, 0xc26, 0xc3e, 0x20, 0x49, 0x49, 0x3b, 0xc30, 0xc1c, 0xc2c, 0xc4d, 0x3b, 0xc37, 0xc2c, 0xc3e, 0xc28, 0xc4d,
0x3b, 0xc30, 0xc02, 0xc1c, 0xc3e, 0xc28, 0xc4d, 0x3b, 0xc37, 0xc35, 0xc4d, 0xc35, 0xc3e, 0xc32, 0xc4d, 0x3b, 0xc27, 0xc41, 0xc32, 0xc4d,
0x2d, 0xc15, 0xc3f, 0x20, 0xc26, 0xc3e, 0xc39, 0xc4d, 0x3b, 0xc27, 0xc41, 0xc32, 0xc4d, 0x2d, 0xc39, 0xc3f, 0xc1c, 0xc4d, 0xc1c, 0xc3e,
0xc39, 0xc4d, 0x3b, 0xe21, 0xe38, 0xe2e, 0xe31, 0xe23, 0x2e, 0x3b, 0xe40, 0xe28, 0xe32, 0xe30, 0x2e, 0x3b, 0xe23, 0xe2d, 0xe1a, 0xe35,
0x20, 0x49, 0x3b, 0xe23, 0xe2d, 0xe1a, 0xe35, 0x20, 0x49, 0x49, 0x3b, 0xe08, 0xe38, 0xe21, 0xe32, 0xe14, 0xe32, 0x20, 0x49, 0x3b,
0xe08, 0xe38, 0xe21, 0xe32, 0xe14, 0xe32, 0x20, 0x49, 0x49, 0x3b, 0xe40, 0xe23, 0xe32, 0xe30, 0x2e, 0x3b, 0xe0a, 0xe30, 0xe2d, 0xe4c,
0x2e, 0x3b, 0xe40, 0xe23, 0xe32, 0xe30, 0xe21, 0xe30, 0x2e, 0x3b, 0xe40, 0xe0a, 0xe32, 0xe27, 0x2e, 0x3b, 0xe0b, 0xe38, 0xe25, 0xe01,
0xe34, 0xe2d, 0xe3a, 0x2e, 0x3b, 0xe0b, 0xe38, 0xe25, 0xe2b, 0xe34, 0xe08, 0x2e, 0x3b, 0xe21, 0xe38, 0xe2e, 0xe30, 0xe23, 0xe4c, 0xe23,
0xe2d, 0xe21, 0x3b, 0xe0b, 0xe2d, 0xe1f, 0xe32, 0xe23, 0xe4c, 0x3b, 0xe23, 0xe2d, 0xe1a, 0xe35, 0x20, 0x49, 0x3b, 0xe23, 0xe2d, 0xe1a,
0xe35, 0x20, 0x49, 0x49, 0x3b, 0xe08, 0xe38, 0xe21, 0xe32, 0xe14, 0xe32, 0x20, 0x49, 0x3b, 0xe08, 0xe38, 0xe21, 0xe32, 0xe14, 0xe32,
0x20, 0x49, 0x49, 0x3b, 0xe23, 0xe2d, 0xe08, 0xe31, 0xe1a, 0x3b, 0xe0a, 0xe30, 0xe2d, 0xe30, 0xe1a, 0xe32, 0xe19, 0x3b, 0xe23, 0xe2d,
0xe21, 0xe30, 0xe14, 0xe2d, 0xe19, 0x3b, 0xe40, 0xe0a, 0xe32, 0xe27, 0xe31, 0xe25, 0x3b, 0xe0b, 0xe38, 0xe25, 0xe01, 0xe34, 0xe2d, 0xe3a,
0xe14, 0xe30, 0xe2e, 0xe3a, 0x3b, 0xe0b, 0xe38, 0xe25, 0xe2b, 0xe34, 0xe08, 0xe0d, 0xe30, 0xe2e, 0xe3a, 0x3b, 0x4d, 0x75, 0x68, 0x3b,
0x53, 0x61, 0x66, 0x3b, 0x4c, 0x61, 0x70, 0x20, 0x49, 0x3b, 0x4c, 0x61, 0x70, 0x20, 0x49, 0x49, 0x3b, 0x53, 0x75, 0x6d,
0x20, 0x49, 0x3b, 0x53, 0x75, 0x6d, 0x20, 0x49, 0x49, 0x3b, 0x4c, 0x61, 0x73, 0x3b, 0x53, 0x61, 0x2bb, 0x61, 0x3b, 0x4c,
0x61, 0x6d, 0x3b, 0x53, 0x61, 0x76, 0x3b, 0x53, 0x16b, 0x2d, 0x6b, 0x3b, 0x53, 0x16b, 0x2d, 0x68, 0x3b, 0x4d, 0x75, 0x68,
0x61, 0x6c, 0x61, 0x6d, 0x69, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x6c, 0x69, 0x3b, 0x4c, 0x61, 0x70, 0x12b, 0x20, 0x49, 0x3b,
0x4c, 0x61, 0x70, 0x12b, 0x20, 0x49, 0x49, 0x3b, 0x53, 0x75, 0x6d, 0x61, 0x74, 0x101, 0x20, 0x49, 0x3b, 0x53, 0x75, 0x6d,
0x61, 0x74, 0x101, 0x20, 0x49, 0x49, 0x3b, 0x4c, 0x61, 0x73, 0x61, 0x70, 0x69, 0x3b, 0x53, 0x61, 0x2bb, 0x61, 0x70, 0x101,
0x6e, 0x69, 0x3b, 0x4c, 0x61, 0x6d, 0x61, 0x74, 0x101, 0x6e, 0x69, 0x3b, 0x53, 0x61, 0x76, 0x101, 0x6c, 0x69, 0x3b, 0x53,
0x16b, 0x2d, 0x6b, 0x61, 0x2bb, 0x61, 0x74, 0x61, 0x3b, 0x53, 0x16b, 0x2d, 0x68, 0x69, 0x73, 0x61, 0x3b, 0x4d, 0x75, 0x68,
0x61, 0x72, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x65, 0x72, 0x3b, 0x52, 0x2e, 0x65, 0x76, 0x76, 0x65, 0x6c, 0x3b, 0x52, 0x2e,
0x61, 0x68, 0x69, 0x72, 0x3b, 0x43, 0x2e, 0x65, 0x76, 0x76, 0x65, 0x6c, 0x3b, 0x43, 0x2e, 0x61, 0x68, 0x69, 0x72, 0x3b,
0x52, 0x65, 0x63, 0x65, 0x70, 0x3b, 0x15e, 0x61, 0x62, 0x61, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x15e, 0x65, 0x76,
0x76, 0x61, 0x6c, 0x3b, 0x5a, 0x69, 0x6c, 0x6b, 0x61, 0x64, 0x65, 0x3b, 0x5a, 0x69, 0x6c, 0x68, 0x69, 0x63, 0x63, 0x65,
0x3b, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x65, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x65, 0x72, 0x3b, 0x52, 0x65, 0x62, 0x69,
0xfc, 0x6c, 0x65, 0x76, 0x76, 0x65, 0x6c, 0x3b, 0x52, 0x65, 0x62, 0x69, 0xfc, 0x6c, 0x61, 0x68, 0x69, 0x72, 0x3b, 0x43,
0x65, 0x6d, 0x61, 0x7a, 0x69, 0x79, 0x65, 0x6c, 0x65, 0x76, 0x76, 0x65, 0x6c, 0x3b, 0x43, 0x65, 0x6d, 0x61, 0x7a, 0x69,
0x79, 0x65, 0x6c, 0x61, 0x68, 0x69, 0x72, 0x3b, 0x52, 0x65, 0x63, 0x65, 0x70, 0x3b, 0x15e, 0x61, 0x62, 0x61, 0x6e, 0x3b,
0x52, 0x61, 0x6d, 0x61, 0x7a, 0x61, 0x6e, 0x3b, 0x15e, 0x65, 0x76, 0x76, 0x61, 0x6c, 0x3b, 0x5a, 0x69, 0x6c, 0x6b, 0x61,
0x64, 0x65, 0x3b, 0x5a, 0x69, 0x6c, 0x68, 0x69, 0x63, 0x63, 0x65, 0x3b, 0x645, 0x6c7, 0x6be, 0x6d5, 0x631, 0x631, 0x6d5, 0x645,
0x3b, 0x633, 0x6d5, 0x67e, 0x6d5, 0x631, 0x3b, 0x631, 0x6d5, 0x628, 0x649, 0x626, 0x6c7, 0x644, 0x626, 0x6d5, 0x6cb, 0x6cb, 0x6d5, 0x644,
0x3b, 0x631, 0x6d5, 0x628, 0x649, 0x626, 0x6c7, 0x644, 0x626, 0x627, 0x62e, 0x649, 0x631, 0x3b, 0x62c, 0x6d5, 0x645, 0x627, 0x62f, 0x649,
0x64a, 0x6d5, 0x644, 0x626, 0x6d5, 0x6cb, 0x6cb, 0x6d5, 0x644, 0x3b, 0x62c, 0x6d5, 0x645, 0x627, 0x62f, 0x649, 0x64a, 0x6d5, 0x644, 0x626,
0x627, 0x62e, 0x649, 0x631, 0x3b, 0x631, 0x6d5, 0x62c, 0x6d5, 0x628, 0x3b, 0x634, 0x6d5, 0x626, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x627,
0x645, 0x649, 0x632, 0x627, 0x646, 0x3b, 0x634, 0x6d5, 0x6cb, 0x6cb, 0x627, 0x644, 0x3b, 0x632, 0x6c7, 0x644, 0x642, 0x6d5, 0x626, 0x62f,
0x6d5, 0x3b, 0x632, 0x6c7, 0x644, 0x6be, 0x6d5, 0x62c, 0x62c, 0x6d5, 0x3b, 0x43c, 0x443, 0x445, 0x3b, 0x441, 0x430, 0x444, 0x3b, 0x440,
0x430, 0x431, 0x456, 0x20, 0x49, 0x3b, 0x440, 0x430, 0x431, 0x456, 0x20, 0x49, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x20, 0x49,
0x3b, 0x434, 0x436, 0x443, 0x43c, 0x20, 0x49, 0x49, 0x3b, 0x440, 0x430, 0x434, 0x436, 0x3b, 0x448, 0x430, 0x430, 0x431, 0x3b, 0x440,
0x430, 0x43c, 0x3b, 0x434, 0x430, 0x432, 0x3b, 0x437, 0x443, 0x2d, 0x43b, 0x44c, 0x2d, 0x43a, 0x3b, 0x437, 0x443, 0x2d, 0x43b, 0x44c,
0x2d, 0x445, 0x3b, 0x43c, 0x443, 0x445, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b, 0x441, 0x430, 0x444, 0x430, 0x440, 0x3b, 0x440, 0x430,
0x431, 0x456, 0x20, 0x49, 0x3b, 0x440, 0x430, 0x431, 0x456, 0x20, 0x49, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430, 0x434, 0x430,
0x20, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x430, 0x434, 0x430, 0x20, 0x49, 0x49, 0x3b, 0x440, 0x430, 0x434, 0x436, 0x430, 0x431,
0x3b, 0x448, 0x430, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x440, 0x430, 0x43c, 0x430, 0x434, 0x430, 0x43d, 0x3b, 0x434, 0x430, 0x432, 0x432,
0x430, 0x43b, 0x3b, 0x437, 0x443, 0x2d, 0x43b, 0x44c, 0x2d, 0x43a, 0x430, 0x430, 0x434, 0x430, 0x3b, 0x437, 0x443, 0x2d, 0x43b, 0x44c,
0x2d, 0x445, 0x456, 0x434, 0x436, 0x430, 0x3b, 0x43c, 0x443, 0x445, 0x2e, 0x3b, 0x441, 0x430, 0x444, 0x2e, 0x3b, 0x440, 0x430, 0x431,
0x456, 0x20, 0x49, 0x3b, 0x440, 0x430, 0x431, 0x456, 0x20, 0x49, 0x49, 0x3b, 0x434, 0x436, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x3b,
0x434, 0x436, 0x443, 0x43c, 0x2e, 0x20, 0x49, 0x49, 0x3b, 0x440, 0x430, 0x434, 0x436, 0x2e, 0x3b, 0x448, 0x430, 0x430, 0x431, 0x2e,
0x3b, 0x440, 0x430, 0x43c, 0x2e, 0x3b, 0x434, 0x430, 0x432, 0x2e, 0x3b, 0x437, 0x443, 0x2d, 0x43b, 0x44c, 0x2d, 0x43a, 0x2e, 0x3b,
0x437, 0x443, 0x2d, 0x43b, 0x44c, 0x2d, 0x445, 0x2e, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628,
0x6cc, 0x639, 0x20, 0x627, 0x644, 0x627, 0x648, 0x651, 0x644, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x62b, 0x651, 0x627,
0x646, 0x6cc, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x627, 0x648, 0x651, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f,
0x6cc, 0x20, 0x627, 0x644, 0x62b, 0x651, 0x627, 0x646, 0x6cc, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b,
0x631, 0x645, 0x636, 0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x648, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x6c3, 0x3b,
0x630, 0x648, 0x627, 0x644, 0x62d, 0x62c, 0x6c3, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x20, 0x628,
0x6cc, 0x639, 0x20, 0x627, 0x644, 0x627, 0x648, 0x644, 0x3b, 0x631, 0x20, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646,
0x6cc, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x627, 0x648, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20,
0x627, 0x644, 0x62b, 0x627, 0x646, 0x6cc, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636,
0x627, 0x646, 0x3b, 0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x648, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x6c3, 0x3b, 0x630, 0x648, 0x627,
0x644, 0x62d, 0x62c, 0x6c3, 0x3b, 0x645, 0x62d, 0x631, 0x645, 0x3b, 0x635, 0x641, 0x631, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627,
0x644, 0x627, 0x648, 0x651, 0x644, 0x3b, 0x631, 0x628, 0x6cc, 0x639, 0x20, 0x627, 0x644, 0x62b, 0x627, 0x646, 0x6cc, 0x3b, 0x62c, 0x645,
0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x627, 0x648, 0x651, 0x644, 0x3b, 0x62c, 0x645, 0x627, 0x62f, 0x6cc, 0x20, 0x627, 0x644, 0x62b,
0x627, 0x646, 0x6cc, 0x3b, 0x631, 0x62c, 0x628, 0x3b, 0x634, 0x639, 0x628, 0x627, 0x646, 0x3b, 0x631, 0x645, 0x636, 0x627, 0x646, 0x3b,
0x634, 0x648, 0x627, 0x644, 0x3b, 0x630, 0x648, 0x627, 0x644, 0x642, 0x639, 0x62f, 0x6c3, 0x3b, 0x630, 0x648, 0x627, 0x644, 0x62d, 0x62c,
0x6c3, 0x3b, 0x4d, 0x75, 0x68, 0x2e, 0x3b, 0x53, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x6f, 0x62, 0x2e, 0x20, 0x61, 0x76, 0x76,
0x2e, 0x3b, 0x52, 0x6f, 0x62, 0x2e, 0x20, 0x6f, 0x78, 0x2e, 0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x61, 0x76, 0x76, 0x2e,
0x3b, 0x4a, 0x75, 0x6d, 0x2e, 0x20, 0x6f, 0x78, 0x2e, 0x3b, 0x52, 0x61, 0x6a, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x2e, 0x3b,
0x52, 0x61, 0x6d, 0x2e, 0x3b, 0x53, 0x68, 0x61, 0x76, 0x2e, 0x3b, 0x5a, 0x75, 0x6c, 0x2d, 0x71, 0x2e, 0x3b, 0x5a, 0x75,
0x6c, 0x2d, 0x68, 0x2e, 0x3b, 0x4d, 0x75, 0x68, 0x61, 0x72, 0x72, 0x61, 0x6d, 0x3b, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b,
0x52, 0x6f, 0x62, 0x69, 0x2019, 0x20, 0x75, 0x6c, 0x2d, 0x61, 0x76, 0x76, 0x61, 0x6c, 0x3b, 0x52, 0x6f, 0x62, 0x69, 0x2019,
0x20, 0x75, 0x6c, 0x2d, 0x6f, 0x78, 0x69, 0x72, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x20, 0x75, 0x6c, 0x2d, 0x61, 0x76,
0x76, 0x61, 0x6c, 0x3b, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x20, 0x75, 0x6c, 0x2d, 0x6f, 0x78, 0x69, 0x72, 0x3b, 0x52, 0x61,
0x6a, 0x61, 0x62, 0x3b, 0x53, 0x68, 0x61, 0x2019, 0x62, 0x6f, 0x6e, 0x3b, 0x52, 0x61, 0x6d, 0x61, 0x7a, 0x6f, 0x6e, 0x3b,
0x53, 0x68, 0x61, 0x76, 0x76, 0x6f, 0x6c, 0x3b, 0x5a, 0x75, 0x6c, 0x2d, 0x71, 0x61, 0x2019, 0x64, 0x61, 0x3b, 0x5a, 0x75,
0x6c, 0x2d, 0x68, 0x69, 0x6a, 0x6a, 0x61, 0x3b, 0x41c, 0x443, 0x4b3, 0x430, 0x440, 0x440, 0x430, 0x43c, 0x3b, 0x421, 0x430, 0x444,
0x430, 0x440, 0x3b, 0x420, 0x430, 0x431, 0x438, 0x443, 0x43b, 0x2d, 0x430, 0x432, 0x432, 0x430, 0x43b, 0x3b, 0x420, 0x430, 0x431, 0x438,
0x443, 0x43b, 0x2d, 0x43e, 0x445, 0x438, 0x440, 0x3b, 0x416, 0x443, 0x43c, 0x43e, 0x434, 0x438, 0x443, 0x43b, 0x2d, 0x443, 0x43b, 0x43e,
0x3b, 0x416, 0x443, 0x43c, 0x43e, 0x434, 0x438, 0x443, 0x43b, 0x2d, 0x443, 0x445, 0x440, 0x43e, 0x3b, 0x420, 0x430, 0x436, 0x430, 0x431,
0x3b, 0x428, 0x430, 0x44a, 0x431, 0x43e, 0x43d, 0x3b, 0x420, 0x430, 0x43c, 0x430, 0x437, 0x43e, 0x43d, 0x3b, 0x428, 0x430, 0x432, 0x432,
0x43e, 0x43b, 0x3b, 0x417, 0x438, 0x43b, 0x2d, 0x49b, 0x430, 0x44a, 0x434, 0x430, 0x3b, 0x417, 0x438, 0x43b, 0x2d, 0x4b3, 0x438, 0x436,
0x436, 0x430, 0x3b, 0x6d, 0x75, 0x68, 0x2e, 0x3b, 0x73, 0x61, 0x66, 0x2e, 0x3b, 0x52, 0x61, 0x62, 0x2e, 0x20, 0x49, 0x3b,
0x72, 0x61, 0x62, 0x2e, 0x20, 0x69, 0x69, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x2e, 0x20, 0x69, 0x3b, 0x64, 0x17e, 0x75, 0x6d,
0x2e, 0x20, 0x69, 0x69, 0x3b, 0x72, 0x65, 0x64, 0x17e, 0x2e, 0x3b, 0x161, 0x61, 0x2e, 0x3b, 0x72, 0x61, 0x6d, 0x2e, 0x3b,
0x161, 0x65, 0x2e, 0x3b, 0x7a, 0x75, 0x6c, 0x2d, 0x6b, 0x2e, 0x3b, 0x7a, 0x75, 0x6c, 0x2d, 0x68, 0x2e, 0x3b, 0x6d, 0x75,
0x68, 0x61, 0x72, 0x65, 0x6d, 0x3b, 0x73, 0x61, 0x66, 0x65, 0x72, 0x3b, 0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x69, 0x3b,
0x72, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x69, 0x69, 0x3b, 0x64, 0x17e, 0x75, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x69, 0x3b, 0x64,
0x17e, 0x75, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x69, 0x69, 0x3b, 0x72, 0x65, 0x64, 0x17e, 0x65, 0x62, 0x3b, 0x53, 0x68, 0x61,
0x2bb, 0x62, 0x61, 0x6e, 0x3b, 0x72, 0x61, 0x6d, 0x61, 0x7a, 0x61, 0x6e, 0x3b, 0x161, 0x65, 0x76, 0x61, 0x6c, 0x3b, 0x7a,
0x75, 0x6c, 0x2d, 0x6b, 0x61, 0x64, 0x65, 0x3b, 0x7a, 0x75, 0x6c, 0x2d, 0x68, 0x69, 0x64, 0x17e, 0x65, 0x3b, 0x64, 0x7a,
0x76, 0x3b, 0x64, 0x7a, 0x64, 0x3b, 0x74, 0x65, 0x64, 0x3b, 0x61, 0x66, 0x254, 0x3b, 0x64, 0x61, 0x6d, 0x3b, 0x6d, 0x61,
0x73, 0x3b, 0x73, 0x69, 0x61, 0x3b, 0x64, 0x65, 0x61, 0x3b, 0x61, 0x6e, 0x79, 0x3b, 0x6b, 0x65, 0x6c, 0x3b, 0x61, 0x64,
0x65, 0x3b, 0x64, 0x7a, 0x6d, 0x3b, 0x64, 0x7a, 0x6f, 0x76, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x64, 0x7a, 0x65, 0x3b, 0x74,
0x65, 0x64, 0x6f, 0x78, 0x65, 0x3b, 0x61, 0x66, 0x254, 0x66, 0x69, 0x1ebd, 0x3b, 0x64, 0x61, 0x6d, 0x25b, 0x3b, 0x6d, 0x61,
0x73, 0x61, 0x3b, 0x73, 0x69, 0x61, 0x6d, 0x6c, 0x254, 0x6d, 0x3b, 0x64, 0x65, 0x61, 0x73, 0x69, 0x61, 0x6d, 0x69, 0x6d,
0x65, 0x3b, 0x61, 0x6e, 0x79, 0x254, 0x6e, 0x79, 0x254, 0x3b, 0x6b, 0x65, 0x6c, 0x65, 0x3b, 0x61, 0x64, 0x65, 0x25b, 0x6d,
0x65, 0x6b, 0x70, 0x254, 0x78, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x6d, 0x65, 0x3b, 0x64, 0x65, 0x20, 0x4d, 0x75, 0x68, 0x61,
0x72, 0x72, 0x61, 0x6d, 0x3b, 0x64, 0x65, 0x20, 0x53, 0x61, 0x66, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x20, 0x52, 0x61, 0x62,
0x69, 0x2bb, 0x20, 0x49, 0x3b, 0x64, 0x65, 0x20, 0x52, 0x61, 0x62, 0x69, 0x2bb, 0x20, 0x49, 0x49, 0x3b, 0x64, 0x65, 0x20,
0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49, 0x3b, 0x64, 0x65, 0x20, 0x4a, 0x75, 0x6d, 0x61, 0x64, 0x61, 0x20, 0x49,
0x49, 0x3b, 0x64, 0x65, 0x20, 0x52, 0x61, 0x6a, 0x61, 0x62, 0x3b, 0x64, 0x65, 0x20, 0x53, 0x68, 0x61, 0x2bb, 0x62, 0x61,
0x6e, 0x3b, 0x64, 0x65, 0x20, 0x52, 0x61, 0x6d, 0x61, 0x64, 0x61, 0x6e, 0x3b, 0x64, 0x65, 0x20, 0x53, 0x68, 0x61, 0x77,
0x77, 0x61, 0x6c, 0x3b, 0x64, 0x65, 0x20, 0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x51, 0x69, 0x2bb, 0x64, 0x61, 0x68, 0x3b,
0x64, 0x65, 0x20, 0x44, 0x68, 0x75, 0x2bb, 0x6c, 0x2d, 0x48, 0x69, 0x6a, 0x6a, 0x61, 0x68, 0x3b, 0x7a46, 0x54c8, 0x5170, 0x59c6,
0x6708, 0x3b, 0x8272, 0x6cd5, 0x5c14, 0x6708, 0x3b, 0x8d56, 0x6bd4, 0x6708, 0x20, 0x49, 0x3b, 0x8d56, 0x6bd4, 0x6708, 0x20, 0x49, 0x49, 0x3b,
0x4e3b, 0x9a6c, 0x8fbe, 0x6708, 0x20, 0x49, 0x3b, 0x4e3b, 0x9a6c, 0x8fbe, 0x6708, 0x20, 0x49, 0x49, 0x3b, 0x8d56, 0x54f2, 0x535c, 0x6708, 0x3b,
0x820d, 0x5c14, 0x90a6, 0x6708, 0x3b, 0x8d56, 0x4e70, 0x4e39, 0x6708, 0x3b, 0x95ea, 0x74e6, 0x9c81, 0x6708, 0x3b, 0x90fd, 0x5c14, 0x5580, 0x5c14, 0x5fb7,
0x6708, 0x3b, 0x90fd, 0x5c14, 0x9ed1, 0x54f2, 0x6708, 0x3b
};
// GENERATED PART ENDS HERE

QT_END_NAMESPACE

#endif // QHIJRI_CALENDAR_DATA_P_H
